@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.SingletonPartitionSchemeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the partition scheme of a singleton-partitioned, or non-partitioned service.
 * @property partitionScheme Enumerates the ways that a service can be partitioned.
 * Expected value is 'Singleton'.
 */
public data class SingletonPartitionSchemeArgs(
    public val partitionScheme: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.SingletonPartitionSchemeArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.SingletonPartitionSchemeArgs =
        com.pulumi.azurenative.servicefabric.inputs.SingletonPartitionSchemeArgs.builder()
            .partitionScheme(partitionScheme.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SingletonPartitionSchemeArgs].
 */
@PulumiTagMarker
public class SingletonPartitionSchemeArgsBuilder internal constructor() {
    private var partitionScheme: Output<String>? = null

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'Singleton'.
     */
    @JvmName("seislolriwuqbwim")
    public suspend fun partitionScheme(`value`: Output<String>) {
        this.partitionScheme = value
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'Singleton'.
     */
    @JvmName("jqtrvowpdsijhfop")
    public suspend fun partitionScheme(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionScheme = mapped
    }

    internal fun build(): SingletonPartitionSchemeArgs = SingletonPartitionSchemeArgs(
        partitionScheme = partitionScheme ?: throw PulumiNullFieldException("partitionScheme"),
    )
}
