@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.StatefulServicePropertiesArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.MoveCost
import com.pulumi.azurenative.servicefabric.kotlin.enums.ServicePackageActivationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a stateful service resource.
 * @property correlationScheme A list that describes the correlation of the service with other services.
 * @property defaultMoveCost Specifies the move cost for the service.
 * @property hasPersistedState A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
 * @property minReplicaSetSize The minimum replica set size as a number.
 * @property partitionDescription Describes how the service is partitioned.
 * @property placementConstraints The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
 * @property quorumLossWaitDuration The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
 * @property replicaRestartWaitDuration The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format "hh:mm:ss".
 * @property scalingPolicies Scaling policies for this service.
 * @property serviceDnsName Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
 * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
 * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
 * @property serviceKind The kind of service (Stateless or Stateful).
 * Expected value is 'Stateful'.
 * @property serviceLoadMetrics The service load metrics is given as an array of ServiceLoadMetric objects.
 * @property servicePackageActivationMode The activation Mode of the service package
 * @property servicePlacementPolicies A list that describes the correlation of the service with other services.
 * @property servicePlacementTimeLimit The duration for which replicas can stay InBuild before reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
 * @property serviceTypeName The name of the service type
 * @property standByReplicaKeepDuration The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
 * @property targetReplicaSetSize The target replica set size as a number.
 */
public data class StatefulServicePropertiesArgs(
    public val correlationScheme: Output<List<ServiceCorrelationArgs>>? = null,
    public val defaultMoveCost: Output<Either<String, MoveCost>>? = null,
    public val hasPersistedState: Output<Boolean>? = null,
    public val minReplicaSetSize: Output<Int>? = null,
    public val partitionDescription: Output<Any>,
    public val placementConstraints: Output<String>? = null,
    public val quorumLossWaitDuration: Output<String>? = null,
    public val replicaRestartWaitDuration: Output<String>? = null,
    public val scalingPolicies: Output<List<ScalingPolicyArgs>>? = null,
    public val serviceDnsName: Output<String>? = null,
    public val serviceKind: Output<String>,
    public val serviceLoadMetrics: Output<List<ServiceLoadMetricArgs>>? = null,
    public val servicePackageActivationMode: Output<Either<String, ServicePackageActivationMode>>? =
        null,
    public val servicePlacementPolicies: Output<List<Any>>? = null,
    public val servicePlacementTimeLimit: Output<String>? = null,
    public val serviceTypeName: Output<String>,
    public val standByReplicaKeepDuration: Output<String>? = null,
    public val targetReplicaSetSize: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.StatefulServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.StatefulServicePropertiesArgs =
        com.pulumi.azurenative.servicefabric.inputs.StatefulServicePropertiesArgs.builder()
            .correlationScheme(
                correlationScheme?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultMoveCost(
                defaultMoveCost?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hasPersistedState(hasPersistedState?.applyValue({ args0 -> args0 }))
            .minReplicaSetSize(minReplicaSetSize?.applyValue({ args0 -> args0 }))
            .partitionDescription(partitionDescription.applyValue({ args0 -> args0 }))
            .placementConstraints(placementConstraints?.applyValue({ args0 -> args0 }))
            .quorumLossWaitDuration(quorumLossWaitDuration?.applyValue({ args0 -> args0 }))
            .replicaRestartWaitDuration(replicaRestartWaitDuration?.applyValue({ args0 -> args0 }))
            .scalingPolicies(
                scalingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceDnsName(serviceDnsName?.applyValue({ args0 -> args0 }))
            .serviceKind(serviceKind.applyValue({ args0 -> args0 }))
            .serviceLoadMetrics(
                serviceLoadMetrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .servicePackageActivationMode(
                servicePackageActivationMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .servicePlacementPolicies(
                servicePlacementPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .servicePlacementTimeLimit(servicePlacementTimeLimit?.applyValue({ args0 -> args0 }))
            .serviceTypeName(serviceTypeName.applyValue({ args0 -> args0 }))
            .standByReplicaKeepDuration(standByReplicaKeepDuration?.applyValue({ args0 -> args0 }))
            .targetReplicaSetSize(targetReplicaSetSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatefulServicePropertiesArgs].
 */
@PulumiTagMarker
public class StatefulServicePropertiesArgsBuilder internal constructor() {
    private var correlationScheme: Output<List<ServiceCorrelationArgs>>? = null

    private var defaultMoveCost: Output<Either<String, MoveCost>>? = null

    private var hasPersistedState: Output<Boolean>? = null

    private var minReplicaSetSize: Output<Int>? = null

    private var partitionDescription: Output<Any>? = null

    private var placementConstraints: Output<String>? = null

    private var quorumLossWaitDuration: Output<String>? = null

    private var replicaRestartWaitDuration: Output<String>? = null

    private var scalingPolicies: Output<List<ScalingPolicyArgs>>? = null

    private var serviceDnsName: Output<String>? = null

    private var serviceKind: Output<String>? = null

    private var serviceLoadMetrics: Output<List<ServiceLoadMetricArgs>>? = null

    private var servicePackageActivationMode: Output<Either<String, ServicePackageActivationMode>>? =
        null

    private var servicePlacementPolicies: Output<List<Any>>? = null

    private var servicePlacementTimeLimit: Output<String>? = null

    private var serviceTypeName: Output<String>? = null

    private var standByReplicaKeepDuration: Output<String>? = null

    private var targetReplicaSetSize: Output<Int>? = null

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("wfrtpinghvfirjsk")
    public suspend fun correlationScheme(`value`: Output<List<ServiceCorrelationArgs>>) {
        this.correlationScheme = value
    }

    @JvmName("mygigegdvxngijbf")
    public suspend fun correlationScheme(vararg values: Output<ServiceCorrelationArgs>) {
        this.correlationScheme = Output.all(values.asList())
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("jaqhnftjcrflcqtb")
    public suspend fun correlationScheme(values: List<Output<ServiceCorrelationArgs>>) {
        this.correlationScheme = Output.all(values)
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("mcvrqfklggqtvrbi")
    public suspend fun defaultMoveCost(`value`: Output<Either<String, MoveCost>>) {
        this.defaultMoveCost = value
    }

    /**
     * @param value A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
     */
    @JvmName("ynmtwhgrycshcvug")
    public suspend fun hasPersistedState(`value`: Output<Boolean>) {
        this.hasPersistedState = value
    }

    /**
     * @param value The minimum replica set size as a number.
     */
    @JvmName("hxbajegwupifwbol")
    public suspend fun minReplicaSetSize(`value`: Output<Int>) {
        this.minReplicaSetSize = value
    }

    /**
     * @param value Describes how the service is partitioned.
     */
    @JvmName("mbgwsdeefqbayonh")
    public suspend fun partitionDescription(`value`: Output<Any>) {
        this.partitionDescription = value
    }

    /**
     * @param value The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
     */
    @JvmName("ubwhxmwvpsldtdmb")
    public suspend fun placementConstraints(`value`: Output<String>) {
        this.placementConstraints = value
    }

    /**
     * @param value The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("hoyblikeogxoxoyy")
    public suspend fun quorumLossWaitDuration(`value`: Output<String>) {
        this.quorumLossWaitDuration = value
    }

    /**
     * @param value The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("pficgjrebyjjltgn")
    public suspend fun replicaRestartWaitDuration(`value`: Output<String>) {
        this.replicaRestartWaitDuration = value
    }

    /**
     * @param value Scaling policies for this service.
     */
    @JvmName("bwcyhmlfqlynuitb")
    public suspend fun scalingPolicies(`value`: Output<List<ScalingPolicyArgs>>) {
        this.scalingPolicies = value
    }

    @JvmName("egpvwtorjximpwok")
    public suspend fun scalingPolicies(vararg values: Output<ScalingPolicyArgs>) {
        this.scalingPolicies = Output.all(values.asList())
    }

    /**
     * @param values Scaling policies for this service.
     */
    @JvmName("gjeufaoeaeogsrub")
    public suspend fun scalingPolicies(values: List<Output<ScalingPolicyArgs>>) {
        this.scalingPolicies = Output.all(values)
    }

    /**
     * @param value Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
     * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
     * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
     */
    @JvmName("giywhvfxltttosdl")
    public suspend fun serviceDnsName(`value`: Output<String>) {
        this.serviceDnsName = value
    }

    /**
     * @param value The kind of service (Stateless or Stateful).
     * Expected value is 'Stateful'.
     */
    @JvmName("sjjoeoavshxqdpnr")
    public suspend fun serviceKind(`value`: Output<String>) {
        this.serviceKind = value
    }

    /**
     * @param value The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("bguoftxwxcwvsawu")
    public suspend fun serviceLoadMetrics(`value`: Output<List<ServiceLoadMetricArgs>>) {
        this.serviceLoadMetrics = value
    }

    @JvmName("fntoybyyfordsepm")
    public suspend fun serviceLoadMetrics(vararg values: Output<ServiceLoadMetricArgs>) {
        this.serviceLoadMetrics = Output.all(values.asList())
    }

    /**
     * @param values The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("mnvaobccxqoxlflv")
    public suspend fun serviceLoadMetrics(values: List<Output<ServiceLoadMetricArgs>>) {
        this.serviceLoadMetrics = Output.all(values)
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("nmsfvsowltrlqltp")
    public suspend
    fun servicePackageActivationMode(`value`: Output<Either<String, ServicePackageActivationMode>>) {
        this.servicePackageActivationMode = value
    }

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("mgrllflxsuhqmivr")
    public suspend fun servicePlacementPolicies(`value`: Output<List<Any>>) {
        this.servicePlacementPolicies = value
    }

    @JvmName("owlhgpryydusafig")
    public suspend fun servicePlacementPolicies(vararg values: Output<Any>) {
        this.servicePlacementPolicies = Output.all(values.asList())
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("qnijofgccvthrlug")
    public suspend fun servicePlacementPolicies(values: List<Output<Any>>) {
        this.servicePlacementPolicies = Output.all(values)
    }

    /**
     * @param value The duration for which replicas can stay InBuild before reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("anpsrvbbmltpaoiq")
    public suspend fun servicePlacementTimeLimit(`value`: Output<String>) {
        this.servicePlacementTimeLimit = value
    }

    /**
     * @param value The name of the service type
     */
    @JvmName("cjjbvnccikffdgph")
    public suspend fun serviceTypeName(`value`: Output<String>) {
        this.serviceTypeName = value
    }

    /**
     * @param value The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("gnnmulghuvjdaamh")
    public suspend fun standByReplicaKeepDuration(`value`: Output<String>) {
        this.standByReplicaKeepDuration = value
    }

    /**
     * @param value The target replica set size as a number.
     */
    @JvmName("splgdypulkrgvgxv")
    public suspend fun targetReplicaSetSize(`value`: Output<Int>) {
        this.targetReplicaSetSize = value
    }

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("rqpfyquyoygudyww")
    public suspend fun correlationScheme(`value`: List<ServiceCorrelationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationScheme = mapped
    }

    /**
     * @param argument A list that describes the correlation of the service with other services.
     */
    @JvmName("kgbpqfrvvghnmril")
    public suspend
    fun correlationScheme(argument: List<suspend ServiceCorrelationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceCorrelationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.correlationScheme = mapped
    }

    /**
     * @param argument A list that describes the correlation of the service with other services.
     */
    @JvmName("qygtnvxcgtuvhypu")
    public suspend fun correlationScheme(
        vararg
        argument: suspend ServiceCorrelationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceCorrelationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.correlationScheme = mapped
    }

    /**
     * @param argument A list that describes the correlation of the service with other services.
     */
    @JvmName("qsesbkkjnvkeuned")
    public suspend fun correlationScheme(argument: suspend ServiceCorrelationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceCorrelationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.correlationScheme = mapped
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("bydqlmmxmwptxmjr")
    public suspend fun correlationScheme(vararg values: ServiceCorrelationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.correlationScheme = mapped
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("ulbprfttxgmhmfvd")
    public suspend fun defaultMoveCost(`value`: Either<String, MoveCost>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMoveCost = mapped
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("jvkcsacnhdiphuxq")
    public fun defaultMoveCost(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MoveCost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMoveCost = mapped
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("iyprrdogjiemixwi")
    public fun defaultMoveCost(`value`: MoveCost) {
        val toBeMapped = Either.ofRight<String, MoveCost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMoveCost = mapped
    }

    /**
     * @param value A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
     */
    @JvmName("knxybglueolctpvq")
    public suspend fun hasPersistedState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasPersistedState = mapped
    }

    /**
     * @param value The minimum replica set size as a number.
     */
    @JvmName("powvwnsvsupofrtf")
    public suspend fun minReplicaSetSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReplicaSetSize = mapped
    }

    /**
     * @param value Describes how the service is partitioned.
     */
    @JvmName("bjxxbtbnasataitf")
    public suspend fun partitionDescription(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionDescription = mapped
    }

    /**
     * @param value The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
     */
    @JvmName("lrdmsinbsixgufve")
    public suspend fun placementConstraints(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("xabmaplcywodkmey")
    public suspend fun quorumLossWaitDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quorumLossWaitDuration = mapped
    }

    /**
     * @param value The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("btumrhicpdawpswi")
    public suspend fun replicaRestartWaitDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaRestartWaitDuration = mapped
    }

    /**
     * @param value Scaling policies for this service.
     */
    @JvmName("ysxdawlqwhjbivaq")
    public suspend fun scalingPolicies(`value`: List<ScalingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPolicies = mapped
    }

    /**
     * @param argument Scaling policies for this service.
     */
    @JvmName("ychkswimmsfkncwl")
    public suspend fun scalingPolicies(argument: List<suspend ScalingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingPolicies = mapped
    }

    /**
     * @param argument Scaling policies for this service.
     */
    @JvmName("owrrhgldwlgatytr")
    public suspend fun scalingPolicies(vararg argument: suspend ScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingPolicies = mapped
    }

    /**
     * @param argument Scaling policies for this service.
     */
    @JvmName("sfbixkmgsgswsayu")
    public suspend fun scalingPolicies(argument: suspend ScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScalingPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scalingPolicies = mapped
    }

    /**
     * @param values Scaling policies for this service.
     */
    @JvmName("gcekygogixyjllch")
    public suspend fun scalingPolicies(vararg values: ScalingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingPolicies = mapped
    }

    /**
     * @param value Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
     * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
     * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
     */
    @JvmName("pamfehbiuhtiihqa")
    public suspend fun serviceDnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDnsName = mapped
    }

    /**
     * @param value The kind of service (Stateless or Stateful).
     * Expected value is 'Stateful'.
     */
    @JvmName("wdwvccbyyyvtlskj")
    public suspend fun serviceKind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceKind = mapped
    }

    /**
     * @param value The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("ogtcmpvximcedlqy")
    public suspend fun serviceLoadMetrics(`value`: List<ServiceLoadMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param argument The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("ayqiqqfkdshektkr")
    public suspend
    fun serviceLoadMetrics(argument: List<suspend ServiceLoadMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceLoadMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param argument The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("gkfluhovoetmkckq")
    public suspend fun serviceLoadMetrics(
        vararg
        argument: suspend ServiceLoadMetricArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceLoadMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param argument The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("xwwldukvpuggbcvm")
    public suspend fun serviceLoadMetrics(argument: suspend ServiceLoadMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceLoadMetricArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param values The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("gvpmohcsdiveksjf")
    public suspend fun serviceLoadMetrics(vararg values: ServiceLoadMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("jrumoxxqkraaahpc")
    public suspend
    fun servicePackageActivationMode(`value`: Either<String, ServicePackageActivationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePackageActivationMode = mapped
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("rwwmmvfkqcpabagf")
    public fun servicePackageActivationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServicePackageActivationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePackageActivationMode = mapped
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("ponknisxxmoxnyri")
    public fun servicePackageActivationMode(`value`: ServicePackageActivationMode) {
        val toBeMapped = Either.ofRight<String, ServicePackageActivationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePackageActivationMode = mapped
    }

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("dxdysppmcxsyptmd")
    public suspend fun servicePlacementPolicies(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePlacementPolicies = mapped
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("kvjqhusbxiufkuiu")
    public suspend fun servicePlacementPolicies(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePlacementPolicies = mapped
    }

    /**
     * @param value The duration for which replicas can stay InBuild before reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("gpegxdjgtanvuays")
    public suspend fun servicePlacementTimeLimit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePlacementTimeLimit = mapped
    }

    /**
     * @param value The name of the service type
     */
    @JvmName("yukupwgcakyvgpfv")
    public suspend fun serviceTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceTypeName = mapped
    }

    /**
     * @param value The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("upqqhhqyryctjmpw")
    public suspend fun standByReplicaKeepDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standByReplicaKeepDuration = mapped
    }

    /**
     * @param value The target replica set size as a number.
     */
    @JvmName("ljousjvernbibdms")
    public suspend fun targetReplicaSetSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetReplicaSetSize = mapped
    }

    internal fun build(): StatefulServicePropertiesArgs = StatefulServicePropertiesArgs(
        correlationScheme = correlationScheme,
        defaultMoveCost = defaultMoveCost,
        hasPersistedState = hasPersistedState,
        minReplicaSetSize = minReplicaSetSize,
        partitionDescription = partitionDescription ?: throw
            PulumiNullFieldException("partitionDescription"),
        placementConstraints = placementConstraints,
        quorumLossWaitDuration = quorumLossWaitDuration,
        replicaRestartWaitDuration = replicaRestartWaitDuration,
        scalingPolicies = scalingPolicies,
        serviceDnsName = serviceDnsName,
        serviceKind = serviceKind ?: throw PulumiNullFieldException("serviceKind"),
        serviceLoadMetrics = serviceLoadMetrics,
        servicePackageActivationMode = servicePackageActivationMode,
        servicePlacementPolicies = servicePlacementPolicies,
        servicePlacementTimeLimit = servicePlacementTimeLimit,
        serviceTypeName = serviceTypeName ?: throw PulumiNullFieldException("serviceTypeName"),
        standByReplicaKeepDuration = standByReplicaKeepDuration,
        targetReplicaSetSize = targetReplicaSetSize,
    )
}
