@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The policy used to clean up unused versions. When the policy is not specified explicitly, the default unused application versions to keep will be 3.
 * @property maxUnusedVersionsToKeep Number of unused versions per application type to keep.
 */
public data class ApplicationTypeVersionsCleanupPolicyResponse(
    public val maxUnusedVersionsToKeep: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ApplicationTypeVersionsCleanupPolicyResponse):
            ApplicationTypeVersionsCleanupPolicyResponse = ApplicationTypeVersionsCleanupPolicyResponse(
            maxUnusedVersionsToKeep = javaType.maxUnusedVersionsToKeep(),
        )
    }
}
