@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents a scaling mechanism for adding or removing instances of stateless service partition.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'ScalePartitionInstanceCount'.
 * @property maxInstanceCount Maximum number of instances of the partition.
 * @property minInstanceCount Minimum number of instances of the partition.
 * @property scaleIncrement The number of instances to add or remove during a scaling operation.
 */
public data class PartitionInstanceCountScaleMechanismResponse(
    public val kind: String,
    public val maxInstanceCount: Int,
    public val minInstanceCount: Int,
    public val scaleIncrement: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.PartitionInstanceCountScaleMechanismResponse):
            PartitionInstanceCountScaleMechanismResponse = PartitionInstanceCountScaleMechanismResponse(
            kind = javaType.kind(),
            maxInstanceCount = javaType.maxInstanceCount(),
            minInstanceCount = javaType.minInstanceCount(),
            scaleIncrement = javaType.scaleIncrement(),
        )
    }
}
