@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a section in the fabric settings of the cluster.
 * @property name The section name of the fabric settings.
 * @property parameters The collection of parameters in the section.
 */
public data class SettingsSectionDescriptionResponse(
    public val name: String,
    public val parameters: List<SettingsParameterDescriptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.SettingsSectionDescriptionResponse):
            SettingsSectionDescriptionResponse = SettingsSectionDescriptionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.SettingsParameterDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
