@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes a Subnet.
 * @property enableIpv6 Indicates wether to enable Ipv6 or not. If not provided, it will take the same configuration as the cluster.
 * @property name Subnet name.
 * @property networkSecurityGroupId Full resource id for the network security group.
 * @property privateEndpointNetworkPolicies Enable or Disable apply network policies on private end point in the subnet.
 * @property privateLinkServiceNetworkPolicies Enable or Disable apply network policies on private link service in the subnet.
 */
public data class SubnetResponse(
    public val enableIpv6: Boolean? = null,
    public val name: String,
    public val networkSecurityGroupId: String? = null,
    public val privateEndpointNetworkPolicies: String? = null,
    public val privateLinkServiceNetworkPolicies: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.SubnetResponse):
            SubnetResponse = SubnetResponse(
            enableIpv6 = javaType.enableIpv6().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkSecurityGroupId = javaType.networkSecurityGroupId().map({ args0 -> args0 }).orElse(null),
            privateEndpointNetworkPolicies = javaType.privateEndpointNetworkPolicies().map({ args0 ->
                args0
            }).orElse(null),
            privateLinkServiceNetworkPolicies = javaType.privateLinkServiceNetworkPolicies().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
