@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.DiagnosticsDescriptionResponse
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ServiceResourceDescriptionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.DiagnosticsDescriptionResponse.Companion.toKotlin as diagnosticsDescriptionResponseToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ServiceResourceDescriptionResponse.Companion.toKotlin as serviceResourceDescriptionResponseToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabricmesh.Application(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Application(builtJavaResource)
    }
}

/**
 * This type describes an application resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * Other available API versions: 2018-07-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateApplication
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.ServiceFabricMesh.Application("application", new()
 *     {
 *         ApplicationResourceName = "sampleApplication",
 *         Description = "Service Fabric Mesh sample application.",
 *         Location = "EastUS",
 *         ResourceGroupName = "sbz_demo",
 *         Services = new[]
 *         {
 *             new AzureNative.ServiceFabricMesh.Inputs.ServiceResourceDescriptionArgs
 *             {
 *                 CodePackages = new[]
 *                 {
 *                     new AzureNative.ServiceFabricMesh.Inputs.ContainerCodePackagePropertiesArgs
 *                     {
 *                         Endpoints = new[]
 *                         {
 *                             new AzureNative.ServiceFabricMesh.Inputs.EndpointPropertiesArgs
 *                             {
 *                                 Name = "helloWorldListener",
 *                                 Port = 80,
 *                             },
 *                         },
 *                         Image = "seabreeze/sbz-helloworld:1.0-alpine",
 *                         Name = "helloWorldCode",
 *                         Resources = new AzureNative.ServiceFabricMesh.Inputs.ResourceRequirementsArgs
 *                         {
 *                             Requests = new AzureNative.ServiceFabricMesh.Inputs.ResourceRequestsArgs
 *                             {
 *                                 Cpu = 1,
 *                                 MemoryInGB = 1,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 Description = "SeaBreeze Hello World Service.",
 *                 Name = "helloWorldService",
 *                 NetworkRefs = new[]
 *                 {
 *                     new AzureNative.ServiceFabricMesh.Inputs.NetworkRefArgs
 *                     {
 *                         EndpointRefs = new[]
 *                         {
 *                             new AzureNative.ServiceFabricMesh.Inputs.EndpointRefArgs
 *                             {
 *                                 Name = "helloWorldListener",
 *                             },
 *                         },
 *                         Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork",
 *                     },
 *                 },
 *                 OsType = "Linux",
 *                 ReplicaCount = 1,
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewApplication(ctx, "application", &servicefabricmesh.ApplicationArgs{
 * 			ApplicationResourceName: pulumi.String("sampleApplication"),
 * 			Description:             pulumi.String("Service Fabric Mesh sample application."),
 * 			Location:                pulumi.String("EastUS"),
 * 			ResourceGroupName:       pulumi.String("sbz_demo"),
 * 			Services: []servicefabricmesh.ServiceResourceDescriptionArgs{
 * 				{
 * 					CodePackages: []servicefabricmesh.ContainerCodePackagePropertiesArgs{
 * 						{
 * 							Endpoints: servicefabricmesh.EndpointPropertiesArray{
 * 								{
 * 									Name: pulumi.String("helloWorldListener"),
 * 									Port: pulumi.Int(80),
 * 								},
 * 							},
 * 							Image: pulumi.String("seabreeze/sbz-helloworld:1.0-alpine"),
 * 							Name:  pulumi.String("helloWorldCode"),
 * 							Resources: {
 * 								Requests: {
 * 									Cpu:        pulumi.Float64(1),
 * 									MemoryInGB: pulumi.Float64(1),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					Description: pulumi.String("SeaBreeze Hello World Service."),
 * 					Name:        pulumi.String("helloWorldService"),
 * 					NetworkRefs: servicefabricmesh.NetworkRefArray{
 * 						{
 * 							EndpointRefs: servicefabricmesh.EndpointRefArray{
 * 								{
 * 									Name: pulumi.String("helloWorldListener"),
 * 								},
 * 							},
 * 							Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork"),
 * 						},
 * 					},
 * 					OsType:       pulumi.String("Linux"),
 * 					ReplicaCount: pulumi.Int(1),
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Application;
 * import com.pulumi.azurenative.servicefabricmesh.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationResourceName("sampleApplication")
 *             .description("Service Fabric Mesh sample application.")
 *             .location("EastUS")
 *             .resourceGroupName("sbz_demo")
 *             .services(Map.ofEntries(
 *                 Map.entry("codePackages", Map.ofEntries(
 *                     Map.entry("endpoints", Map.ofEntries(
 *                         Map.entry("name", "helloWorldListener"),
 *                         Map.entry("port", 80)
 *                     )),
 *                     Map.entry("image", "seabreeze/sbz-helloworld:1.0-alpine"),
 *                     Map.entry("name", "helloWorldCode"),
 *                     Map.entry("resources", Map.of("requests", Map.ofEntries(
 *                         Map.entry("cpu", 1),
 *                         Map.entry("memoryInGB", 1)
 *                     )))
 *                 )),
 *                 Map.entry("description", "SeaBreeze Hello World Service."),
 *                 Map.entry("name", "helloWorldService"),
 *                 Map.entry("networkRefs", Map.ofEntries(
 *                     Map.entry("endpointRefs", Map.of("name", "helloWorldListener")),
 *                     Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork")
 *                 )),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("replicaCount", 1)
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Application sampleApplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/applications/{applicationResourceName}
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabricmesh.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * Internal - used by Visual Studio to setup the debugging session on the local development environment.
     */
    public val debugParams: Output<String>?
        get() = javaResource.debugParams().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User readable description of the application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the diagnostics definition and usage for an application resource.
     */
    public val diagnostics: Output<DiagnosticsDescriptionResponse>?
        get() = javaResource.diagnostics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    diagnosticsDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes the health state of an application resource.
     */
    public val healthState: Output<String>
        get() = javaResource.healthState().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Names of the services in the application.
     */
    public val serviceNames: Output<List<String>>
        get() = javaResource.serviceNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    public val services: Output<List<ServiceResourceDescriptionResponse>>?
        get() = javaResource.services().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> serviceResourceDescriptionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Status of the application.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Gives additional information about the current status of the application.
     */
    public val statusDetails: Output<String>
        get() = javaResource.statusDetails().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
     */
    public val unhealthyEvaluation: Output<String>
        get() = javaResource.unhealthyEvaluation().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabricmesh.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.azurenative.servicefabricmesh.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit):
    Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
