@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a volume whose lifetime is scoped to the application's lifetime.
 * @property creationParameters Describes parameters for creating application-scoped volumes.
 * @property destinationPath The path within the container at which the volume should be mounted. Only valid path characters are allowed.
 * @property name Name of the volume being referenced.
 * @property readOnly The flag indicating whether the volume is read only. Default is 'false'.
 */
public data class ApplicationScopedVolumeArgs(
    public val creationParameters:
    Output<ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs>,
    public val destinationPath: Output<String>,
    public val name: Output<String>,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeArgs.builder()
            .creationParameters(
                creationParameters.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .destinationPath(destinationPath.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationScopedVolumeArgs].
 */
@PulumiTagMarker
public class ApplicationScopedVolumeArgsBuilder internal constructor() {
    private var creationParameters:
        Output<ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs>? = null

    private var destinationPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value Describes parameters for creating application-scoped volumes.
     */
    @JvmName("otxbxnrcytjdcdhp")
    public suspend
    fun creationParameters(`value`: Output<ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs>) {
        this.creationParameters = value
    }

    /**
     * @param value The path within the container at which the volume should be mounted. Only valid path characters are allowed.
     */
    @JvmName("ubmvltejytbykers")
    public suspend fun destinationPath(`value`: Output<String>) {
        this.destinationPath = value
    }

    /**
     * @param value Name of the volume being referenced.
     */
    @JvmName("nwulxmqjjtekffgf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The flag indicating whether the volume is read only. Default is 'false'.
     */
    @JvmName("urqwfqkcnvnfwmld")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Describes parameters for creating application-scoped volumes.
     */
    @JvmName("saooskkiaksmrege")
    public suspend
    fun creationParameters(`value`: ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.creationParameters = mapped
    }

    /**
     * @param argument Describes parameters for creating application-scoped volumes.
     */
    @JvmName("eeowckmvlwlxewqh")
    public suspend
    fun creationParameters(argument: suspend ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.creationParameters = mapped
    }

    /**
     * @param value The path within the container at which the volume should be mounted. Only valid path characters are allowed.
     */
    @JvmName("eeaykmwuuuoalneg")
    public suspend fun destinationPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPath = mapped
    }

    /**
     * @param value Name of the volume being referenced.
     */
    @JvmName("orachqbgmhptcpcd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The flag indicating whether the volume is read only. Default is 'false'.
     */
    @JvmName("ybaqqpsenevuusht")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): ApplicationScopedVolumeArgs = ApplicationScopedVolumeArgs(
        creationParameters = creationParameters ?: throw PulumiNullFieldException("creationParameters"),
        destinationPath = destinationPath ?: throw PulumiNullFieldException("destinationPath"),
        name = name ?: throw PulumiNullFieldException("name"),
        readOnly = readOnly,
    )
}
