@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.enums.SizeTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes parameters for creating application-scoped volumes provided by Service Fabric Volume Disks
 * @property description User readable description of the volume.
 * @property kind Specifies the application-scoped volume kind.
 * Expected value is 'ServiceFabricVolumeDisk'.
 * @property sizeDisk Volume size
 */
public data class ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs(
    public val description: Output<String>? = null,
    public val kind: Output<String>,
    public val sizeDisk: Output<Either<String, SizeTypes>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .sizeDisk(
                sizeDisk.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs].
 */
@PulumiTagMarker
public class ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgsBuilder internal
constructor() {
    private var description: Output<String>? = null

    private var kind: Output<String>? = null

    private var sizeDisk: Output<Either<String, SizeTypes>>? = null

    /**
     * @param value User readable description of the volume.
     */
    @JvmName("oxgvrgpymsklaidl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the application-scoped volume kind.
     * Expected value is 'ServiceFabricVolumeDisk'.
     */
    @JvmName("lpieerycjptoiqrh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Volume size
     */
    @JvmName("euepkojlqioexsqb")
    public suspend fun sizeDisk(`value`: Output<Either<String, SizeTypes>>) {
        this.sizeDisk = value
    }

    /**
     * @param value User readable description of the volume.
     */
    @JvmName("wviqalihpejnjojd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the application-scoped volume kind.
     * Expected value is 'ServiceFabricVolumeDisk'.
     */
    @JvmName("lvcrvptkiheyygnc")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Volume size
     */
    @JvmName("iubqushmbqrwbrnr")
    public suspend fun sizeDisk(`value`: Either<String, SizeTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeDisk = mapped
    }

    /**
     * @param value Volume size
     */
    @JvmName("dtygpdrqcafivpgv")
    public fun sizeDisk(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeDisk = mapped
    }

    /**
     * @param value Volume size
     */
    @JvmName("hqnclwabsljwsxpm")
    public fun sizeDisk(`value`: SizeTypes) {
        val toBeMapped = Either.ofRight<String, SizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeDisk = mapped
    }

    internal fun build(): ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs =
        ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskArgs(
            description = description,
            kind = kind ?: throw PulumiNullFieldException("kind"),
            sizeDisk = sizeDisk ?: throw PulumiNullFieldException("sizeDisk"),
        )
}
