@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a rule for http route matching.
 * @property headers headers and their values to match in request.
 * @property path Path to match for routing.
 */
public data class HttpRouteMatchRuleArgs(
    public val headers: Output<List<HttpRouteMatchHeaderArgs>>? = null,
    public val path: Output<HttpRouteMatchPathArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchRuleArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchRuleArgs.builder()
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .path(path.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HttpRouteMatchRuleArgs].
 */
@PulumiTagMarker
public class HttpRouteMatchRuleArgsBuilder internal constructor() {
    private var headers: Output<List<HttpRouteMatchHeaderArgs>>? = null

    private var path: Output<HttpRouteMatchPathArgs>? = null

    /**
     * @param value headers and their values to match in request.
     */
    @JvmName("vdavvyuampbgqrba")
    public suspend fun headers(`value`: Output<List<HttpRouteMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("qdldtogijhvvdhsi")
    public suspend fun headers(vararg values: Output<HttpRouteMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values headers and their values to match in request.
     */
    @JvmName("fsgfiyjrniowjovc")
    public suspend fun headers(values: List<Output<HttpRouteMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Path to match for routing.
     */
    @JvmName("ymbtcurqqnyygsda")
    public suspend fun path(`value`: Output<HttpRouteMatchPathArgs>) {
        this.path = value
    }

    /**
     * @param value headers and their values to match in request.
     */
    @JvmName("vmlwncmkhbcbhdau")
    public suspend fun headers(`value`: List<HttpRouteMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument headers and their values to match in request.
     */
    @JvmName("vutadhykjgfhnrus")
    public suspend fun headers(argument: List<suspend HttpRouteMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HttpRouteMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument headers and their values to match in request.
     */
    @JvmName("ceshyucphddcgvag")
    public suspend fun headers(vararg argument: suspend HttpRouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HttpRouteMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument headers and their values to match in request.
     */
    @JvmName("elxkmhemuqkfmocl")
    public suspend fun headers(argument: suspend HttpRouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HttpRouteMatchHeaderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values headers and their values to match in request.
     */
    @JvmName("dbxkdobfdptmeqnj")
    public suspend fun headers(vararg values: HttpRouteMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Path to match for routing.
     */
    @JvmName("abfgxfneatlxejcn")
    public suspend fun path(`value`: HttpRouteMatchPathArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Path to match for routing.
     */
    @JvmName("macdfpxcnprubdqc")
    public suspend fun path(argument: suspend HttpRouteMatchPathArgsBuilder.() -> Unit) {
        val toBeMapped = HttpRouteMatchPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    internal fun build(): HttpRouteMatchRuleArgs = HttpRouteMatchRuleArgs(
        headers = headers,
        path = path ?: throw PulumiNullFieldException("path"),
    )
}
