@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ListSecretValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Azure resource group name
 * @property secretResourceName The name of the secret resource.
 * @property secretValueResourceName The name of the secret resource value which is typically the version identifier for the value.
 */
public data class ListSecretValuePlainArgs(
    public val resourceGroupName: String,
    public val secretResourceName: String,
    public val secretValueResourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ListSecretValuePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ListSecretValuePlainArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ListSecretValuePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .secretResourceName(secretResourceName.let({ args0 -> args0 }))
            .secretValueResourceName(secretValueResourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSecretValuePlainArgs].
 */
@PulumiTagMarker
public class ListSecretValuePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var secretResourceName: String? = null

    private var secretValueResourceName: String? = null

    /**
     * @param value Azure resource group name
     */
    @JvmName("evlwaqasskbpkvkh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the secret resource.
     */
    @JvmName("shbjgkudeiksaryi")
    public suspend fun secretResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretResourceName = mapped
    }

    /**
     * @param value The name of the secret resource value which is typically the version identifier for the value.
     */
    @JvmName("vttvivcfxnfudtco")
    public suspend fun secretValueResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretValueResourceName = mapped
    }

    internal fun build(): ListSecretValuePlainArgs = ListSecretValuePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        secretResourceName = secretResourceName ?: throw PulumiNullFieldException("secretResourceName"),
        secretValueResourceName = secretValueResourceName ?: throw
            PulumiNullFieldException("secretValueResourceName"),
    )
}
