@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.VolumeProviderParametersAzureFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This type describes a volume provided by an Azure Files file share.
 * @property accountKey Access key of the Azure storage account for the File Share.
 * @property accountName Name of the Azure storage account for the File Share.
 * @property shareName Name of the Azure Files file share that provides storage for the volume.
 */
public data class VolumeProviderParametersAzureFileArgs(
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>,
    public val shareName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.VolumeProviderParametersAzureFileArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.VolumeProviderParametersAzureFileArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.VolumeProviderParametersAzureFileArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .shareName(shareName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeProviderParametersAzureFileArgs].
 */
@PulumiTagMarker
public class VolumeProviderParametersAzureFileArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var shareName: Output<String>? = null

    /**
     * @param value Access key of the Azure storage account for the File Share.
     */
    @JvmName("dvgjfdmjtourdkmd")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value Name of the Azure storage account for the File Share.
     */
    @JvmName("rjwcmruegurenxov")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Name of the Azure Files file share that provides storage for the volume.
     */
    @JvmName("asrghhmhxohhaqtc")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Access key of the Azure storage account for the File Share.
     */
    @JvmName("qsexcebfqgurdjky")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value Name of the Azure storage account for the File Share.
     */
    @JvmName("diylocmpfhklrtat")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Name of the Azure Files file share that provides storage for the volume.
     */
    @JvmName("diopuarcsjrntgml")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    internal fun build(): VolumeProviderParametersAzureFileArgs =
        VolumeProviderParametersAzureFileArgs(
            accountKey = accountKey,
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            shareName = shareName ?: throw PulumiNullFieldException("shareName"),
        )
}
