@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes parameters for creating application-scoped volumes provided by Service Fabric Volume Disks
 * @property description User readable description of the volume.
 * @property kind Specifies the application-scoped volume kind.
 * Expected value is 'ServiceFabricVolumeDisk'.
 * @property sizeDisk Volume size
 */
public data class ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse(
    public val description: String? = null,
    public val kind: String,
    public val sizeDisk: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse):
            ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse =
            ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                kind = javaType.kind(),
                sizeDisk = javaType.sizeDisk(),
            )
    }
}
