@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the average load trigger used for auto scaling.
 * @property kind Enumerates the triggers for auto scaling.
 * Expected value is 'AverageLoad'.
 * @property lowerLoadThreshold Lower load threshold (if average load is below this threshold, service will scale down).
 * @property metric Description of the metric that is used for scaling.
 * @property scaleIntervalInSeconds Scale interval that indicates how often will this trigger be checked.
 * @property upperLoadThreshold Upper load threshold (if average load is above this threshold, service will scale up).
 */
public data class AverageLoadScalingTriggerResponse(
    public val kind: String,
    public val lowerLoadThreshold: Double,
    public val metric: AutoScalingResourceMetricResponse,
    public val scaleIntervalInSeconds: Int,
    public val upperLoadThreshold: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.AverageLoadScalingTriggerResponse):
            AverageLoadScalingTriggerResponse = AverageLoadScalingTriggerResponse(
            kind = javaType.kind(),
            lowerLoadThreshold = javaType.lowerLoadThreshold(),
            metric = javaType.metric().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.AutoScalingResourceMetricResponse.Companion.toKotlin(args0)
            }),
            scaleIntervalInSeconds = javaType.scaleIntervalInSeconds(),
            upperLoadThreshold = javaType.upperLoadThreshold(),
        )
    }
}
