@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A container event.
 * @property count The count of the event.
 * @property firstTimestamp Date/time of the first event.
 * @property lastTimestamp Date/time of the last event.
 * @property message The event message
 * @property name The name of the container event.
 * @property type The event type.
 */
public data class ContainerEventResponse(
    public val count: Int? = null,
    public val firstTimestamp: String? = null,
    public val lastTimestamp: String? = null,
    public val message: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ContainerEventResponse):
            ContainerEventResponse = ContainerEventResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            firstTimestamp = javaType.firstTimestamp().map({ args0 -> args0 }).orElse(null),
            lastTimestamp = javaType.lastTimestamp().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
