@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The container state.
 * @property detailStatus Human-readable status of this state.
 * @property exitCode The container exit code.
 * @property finishTime Date/time when the container state finished.
 * @property startTime Date/time when the container state started.
 * @property state The state of this container
 */
public data class ContainerStateResponse(
    public val detailStatus: String? = null,
    public val exitCode: String? = null,
    public val finishTime: String? = null,
    public val startTime: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ContainerStateResponse):
            ContainerStateResponse = ContainerStateResponse(
            detailStatus = javaType.detailStatus().map({ args0 -> args0 }).orElse(null),
            exitCode = javaType.exitCode().map({ args0 -> args0 }).orElse(null),
            finishTime = javaType.finishTime().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
