@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an environment variable for the container.
 * @property name The name of the environment variable.
 * @property value The value of the environment variable.
 */
public data class EnvironmentVariableResponse(
    public val name: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.EnvironmentVariableResponse):
            EnvironmentVariableResponse = EnvironmentVariableResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
