@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a rule for http route matching.
 * @property headers headers and their values to match in request.
 * @property path Path to match for routing.
 */
public data class HttpRouteMatchRuleResponse(
    public val headers: List<HttpRouteMatchHeaderResponse>? = null,
    public val path: HttpRouteMatchPathResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.HttpRouteMatchRuleResponse):
            HttpRouteMatchRuleResponse = HttpRouteMatchRuleResponse(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpRouteMatchHeaderResponse.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpRouteMatchPathResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
