@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.SecretStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An option to store secret value in secure place
 * @property keyVaultId The key vault id to store secret
 * @property keyVaultSecretName The key vault secret name to store secret, only valid when storing one secret
 */
public data class SecretStoreArgs(
    public val keyVaultId: Output<String>? = null,
    public val keyVaultSecretName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.SecretStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.SecretStoreArgs =
        com.pulumi.azurenative.servicelinker.inputs.SecretStoreArgs.builder()
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultSecretName(keyVaultSecretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretStoreArgs].
 */
@PulumiTagMarker
public class SecretStoreArgsBuilder internal constructor() {
    private var keyVaultId: Output<String>? = null

    private var keyVaultSecretName: Output<String>? = null

    /**
     * @param value The key vault id to store secret
     */
    @JvmName("mkgrdqbdmxdlfewd")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value The key vault secret name to store secret, only valid when storing one secret
     */
    @JvmName("psnfdutujyuklbqa")
    public suspend fun keyVaultSecretName(`value`: Output<String>) {
        this.keyVaultSecretName = value
    }

    /**
     * @param value The key vault id to store secret
     */
    @JvmName("eigoatmyacwutgwn")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value The key vault secret name to store secret, only valid when storing one secret
     */
    @JvmName("svbouwgxhupugiye")
    public suspend fun keyVaultSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretName = mapped
    }

    internal fun build(): SecretStoreArgs = SecretStoreArgs(
        keyVaultId = keyVaultId,
        keyVaultSecretName = keyVaultSecretName,
    )
}
