@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.SelfHostedServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The service properties when target service type is SelfHostedServer
 * @property endpoint The endpoint of service.
 * @property type The target service type.
 * Expected value is 'SelfHostedServer'.
 */
public data class SelfHostedServerArgs(
    public val endpoint: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.SelfHostedServerArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.SelfHostedServerArgs =
        com.pulumi.azurenative.servicelinker.inputs.SelfHostedServerArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelfHostedServerArgs].
 */
@PulumiTagMarker
public class SelfHostedServerArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The endpoint of service.
     */
    @JvmName("lyoggtjyioyuseuq")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The target service type.
     * Expected value is 'SelfHostedServer'.
     */
    @JvmName("yvhpingybdtccrfq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint of service.
     */
    @JvmName("jfgcghtiphbyaspo")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The target service type.
     * Expected value is 'SelfHostedServer'.
     */
    @JvmName("omhnjenidnuwcpbp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SelfHostedServerArgs = SelfHostedServerArgs(
        endpoint = endpoint,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
