@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.UserAccountAuthInfoArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The authentication info when authType is user account
 * @property authType The authentication type.
 * Expected value is 'userAccount'.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property principalId Principal Id for user account.
 * @property roles Optional, this value specifies the Azure roles to be assigned. Automatically
 * @property userName Username created in the database which is mapped to a user in AAD.
 */
public data class UserAccountAuthInfoArgs(
    public val authType: Output<String>,
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
    public val principalId: Output<String>? = null,
    public val roles: Output<List<String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.UserAccountAuthInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.UserAccountAuthInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.UserAccountAuthInfoArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAccountAuthInfoArgs].
 */
@PulumiTagMarker
public class UserAccountAuthInfoArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    private var principalId: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'userAccount'.
     */
    @JvmName("egmorvpionkbslam")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("ovkdhojwwnwvnnut")
    public suspend
    fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Principal Id for user account.
     */
    @JvmName("svxbisxfekhoyevx")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("lmetxqefoamedxyo")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("aupclqxhirmmwwgt")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("yygtpfjuxarqovme")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Username created in the database which is mapped to a user in AAD.
     */
    @JvmName("hqoxrjpgfnuharyb")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The authentication type.
     * Expected value is 'userAccount'.
     */
    @JvmName("owauwnjuvciqxsxt")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("dcndatpscmtxbilh")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("skecldcrhhgpdceu")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("utfcibqxjfmwntga")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Principal Id for user account.
     */
    @JvmName("wifxuibvcecapbak")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("lliggfknouprluqv")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("vnifuoigqcjhhxmq")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Username created in the database which is mapped to a user in AAD.
     */
    @JvmName("slhwuacgkmvkpuxq")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserAccountAuthInfoArgs = UserAccountAuthInfoArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        deleteOrUpdateBehavior = deleteOrUpdateBehavior,
        principalId = principalId,
        roles = roles,
        userName = userName,
    )
}
