@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ValueSecretInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The secret info when type is rawValue. It's for scenarios that user input the secret.
 * @property secretType The secret type.
 * Expected value is 'rawValue'.
 * @property value The actual value of the secret.
 */
public data class ValueSecretInfoArgs(
    public val secretType: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ValueSecretInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.ValueSecretInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.ValueSecretInfoArgs.builder()
            .secretType(secretType.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ValueSecretInfoArgs].
 */
@PulumiTagMarker
public class ValueSecretInfoArgsBuilder internal constructor() {
    private var secretType: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The secret type.
     * Expected value is 'rawValue'.
     */
    @JvmName("nqymmmttrwdppvjr")
    public suspend fun secretType(`value`: Output<String>) {
        this.secretType = value
    }

    /**
     * @param value The actual value of the secret.
     */
    @JvmName("joearhohnhvlkwis")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The secret type.
     * Expected value is 'rawValue'.
     */
    @JvmName("kvpxdpppvmnxhebb")
    public suspend fun secretType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretType = mapped
    }

    /**
     * @param value The actual value of the secret.
     */
    @JvmName("hwngfsqkjcgfllbr")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ValueSecretInfoArgs = ValueSecretInfoArgs(
        secretType = secretType ?: throw PulumiNullFieldException("secretType"),
        `value` = `value`,
    )
}
