@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The preview of the operations for creation
 * @property action The action defined by RBAC, refer https://docs.microsoft.com/azure/role-based-access-control/role-definitions#actions-format
 * @property description The description of the operation
 * @property name The operation name
 * @property operationType The operation type
 * @property scope The scope of the operation, refer https://docs.microsoft.com/azure/role-based-access-control/scope-overview
 */
public data class DryrunOperationPreviewResponse(
    public val action: String? = null,
    public val description: String? = null,
    public val name: String? = null,
    public val operationType: String? = null,
    public val scope: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.DryrunOperationPreviewResponse):
            DryrunOperationPreviewResponse = DryrunOperationPreviewResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            operationType = javaType.operationType().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
        )
    }
}
