@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Target service's firewall rules. to allow connections from source service.
 * @property azureServices Allow Azure services to access the target service if true.
 * @property callerClientIP Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
 * @property ipRanges This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
 */
public data class FirewallRulesResponse(
    public val azureServices: String? = null,
    public val callerClientIP: String? = null,
    public val ipRanges: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.FirewallRulesResponse):
            FirewallRulesResponse = FirewallRulesResponse(
            azureServices = javaType.azureServices().map({ args0 -> args0 }).orElse(null),
            callerClientIP = javaType.callerClientIP().map({ args0 -> args0 }).orElse(null),
            ipRanges = javaType.ipRanges().map({ args0 -> args0 }),
        )
    }
}
