@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The authentication info when authType is user account
 * @property authType The authentication type.
 * Expected value is 'userAccount'.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property principalId Principal Id for user account.
 * @property roles Optional, this value specifies the Azure roles to be assigned. Automatically
 * @property userName Username created in the database which is mapped to a user in AAD.
 */
public data class UserAccountAuthInfoResponse(
    public val authType: String,
    public val deleteOrUpdateBehavior: String? = null,
    public val principalId: String? = null,
    public val roles: List<String>? = null,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.UserAccountAuthInfoResponse):
            UserAccountAuthInfoResponse = UserAccountAuthInfoResponse(
            authType = javaType.authType(),
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 -> args0 }),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
