@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.FrontendsInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Frontend Subresource of Traffic Controller.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-10-01-preview.
 * Other available API versions: 2022-10-01-preview, 2023-11-01.
 * ## Example Usage
 * ### Put Frontend
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var frontendsInterface = new AzureNative.ServiceNetworking.FrontendsInterface("frontendsInterface", new()
 *     {
 *         FrontendName = "fe1",
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         TrafficControllerName = "tc1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewFrontendsInterface(ctx, "frontendsInterface", &servicenetworking.FrontendsInterfaceArgs{
 * 			FrontendName:          pulumi.String("fe1"),
 * 			Location:              pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.FrontendsInterface;
 * import com.pulumi.azurenative.servicenetworking.FrontendsInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontendsInterface = new FrontendsInterface("frontendsInterface", FrontendsInterfaceArgs.builder()
 *             .frontendName("fe1")
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .trafficControllerName("tc1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:FrontendsInterface fe1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}/frontends/{frontendName}
 * ```
 * @property frontendName Frontends
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property trafficControllerName traffic controller name for path
 */
public data class FrontendsInterfaceArgs(
    public val frontendName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficControllerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicenetworking.FrontendsInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.FrontendsInterfaceArgs =
        com.pulumi.azurenative.servicenetworking.FrontendsInterfaceArgs.builder()
            .frontendName(frontendName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficControllerName(trafficControllerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrontendsInterfaceArgs].
 */
@PulumiTagMarker
public class FrontendsInterfaceArgsBuilder internal constructor() {
    private var frontendName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficControllerName: Output<String>? = null

    /**
     * @param value Frontends
     */
    @JvmName("brfxryfrunpimkwe")
    public suspend fun frontendName(`value`: Output<String>) {
        this.frontendName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nnmuatfqryqtqrpk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ywhburvnmkfrtuvx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ynawwipkwsawneck")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("joimaneivxorkkal")
    public suspend fun trafficControllerName(`value`: Output<String>) {
        this.trafficControllerName = value
    }

    /**
     * @param value Frontends
     */
    @JvmName("botjrtqnkqvsilyo")
    public suspend fun frontendName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("croglgxgmkfuoeeh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("suypooamclkcomco")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wyxwfdmlkotcevaa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jxcrgfgfajcxynru")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("aoggjaswxofeudpl")
    public suspend fun trafficControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficControllerName = mapped
    }

    internal fun build(): FrontendsInterfaceArgs = FrontendsInterfaceArgs(
        frontendName = frontendName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        trafficControllerName = trafficControllerName,
    )
}
