@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.ServicenetworkingFunctions.getAssociationsInterfacePlain
import com.pulumi.azurenative.servicenetworking.ServicenetworkingFunctions.getFrontendsInterfacePlain
import com.pulumi.azurenative.servicenetworking.ServicenetworkingFunctions.getTrafficControllerInterfacePlain
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.GetAssociationsInterfacePlainArgs
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.GetAssociationsInterfacePlainArgsBuilder
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.GetFrontendsInterfacePlainArgs
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.GetFrontendsInterfacePlainArgsBuilder
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.GetTrafficControllerInterfacePlainArgs
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.GetTrafficControllerInterfacePlainArgsBuilder
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.GetAssociationsInterfaceResult
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.GetFrontendsInterfaceResult
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.GetTrafficControllerInterfaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.GetAssociationsInterfaceResult.Companion.toKotlin as getAssociationsInterfaceResultToKotlin
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.GetFrontendsInterfaceResult.Companion.toKotlin as getFrontendsInterfaceResultToKotlin
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.GetTrafficControllerInterfaceResult.Companion.toKotlin as getTrafficControllerInterfaceResultToKotlin

public object ServicenetworkingFunctions {
    /**
     * Get a Association
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2022-10-01-preview, 2023-11-01.
     * @param argument null
     * @return Association Subresource of Traffic Controller
     */
    public suspend fun getAssociationsInterface(argument: GetAssociationsInterfacePlainArgs):
        GetAssociationsInterfaceResult =
        getAssociationsInterfaceResultToKotlin(getAssociationsInterfacePlain(argument.toJava()).await())

    /**
     * @see [getAssociationsInterface].
     * @param associationName Name of Association
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param trafficControllerName traffic controller name for path
     * @return Association Subresource of Traffic Controller
     */
    public suspend fun getAssociationsInterface(
        associationName: String,
        resourceGroupName: String,
        trafficControllerName: String,
    ): GetAssociationsInterfaceResult {
        val argument = GetAssociationsInterfacePlainArgs(
            associationName = associationName,
            resourceGroupName = resourceGroupName,
            trafficControllerName = trafficControllerName,
        )
        return getAssociationsInterfaceResultToKotlin(getAssociationsInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getAssociationsInterface].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicenetworking&#46;kotlin&#46;inputs&#46;GetAssociationsInterfacePlainArgs].
     * @return Association Subresource of Traffic Controller
     */
    public suspend
    fun getAssociationsInterface(argument: suspend GetAssociationsInterfacePlainArgsBuilder.() -> Unit):
        GetAssociationsInterfaceResult {
        val builder = GetAssociationsInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssociationsInterfaceResultToKotlin(getAssociationsInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Frontend
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2022-10-01-preview, 2023-11-01.
     * @param argument null
     * @return Frontend Subresource of Traffic Controller.
     */
    public suspend fun getFrontendsInterface(argument: GetFrontendsInterfacePlainArgs):
        GetFrontendsInterfaceResult =
        getFrontendsInterfaceResultToKotlin(getFrontendsInterfacePlain(argument.toJava()).await())

    /**
     * @see [getFrontendsInterface].
     * @param frontendName Frontends
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param trafficControllerName traffic controller name for path
     * @return Frontend Subresource of Traffic Controller.
     */
    public suspend fun getFrontendsInterface(
        frontendName: String,
        resourceGroupName: String,
        trafficControllerName: String,
    ): GetFrontendsInterfaceResult {
        val argument = GetFrontendsInterfacePlainArgs(
            frontendName = frontendName,
            resourceGroupName = resourceGroupName,
            trafficControllerName = trafficControllerName,
        )
        return getFrontendsInterfaceResultToKotlin(getFrontendsInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getFrontendsInterface].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicenetworking&#46;kotlin&#46;inputs&#46;GetFrontendsInterfacePlainArgs].
     * @return Frontend Subresource of Traffic Controller.
     */
    public suspend
    fun getFrontendsInterface(argument: suspend GetFrontendsInterfacePlainArgsBuilder.() -> Unit):
        GetFrontendsInterfaceResult {
        val builder = GetFrontendsInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFrontendsInterfaceResultToKotlin(getFrontendsInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a TrafficController
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2022-10-01-preview, 2023-11-01.
     * @param argument null
     * @return Concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    public suspend
    fun getTrafficControllerInterface(argument: GetTrafficControllerInterfacePlainArgs):
        GetTrafficControllerInterfaceResult =
        getTrafficControllerInterfaceResultToKotlin(getTrafficControllerInterfacePlain(argument.toJava()).await())

    /**
     * @see [getTrafficControllerInterface].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param trafficControllerName traffic controller name for path
     * @return Concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getTrafficControllerInterface(
        resourceGroupName: String,
        trafficControllerName: String,
    ): GetTrafficControllerInterfaceResult {
        val argument = GetTrafficControllerInterfacePlainArgs(
            resourceGroupName = resourceGroupName,
            trafficControllerName = trafficControllerName,
        )
        return getTrafficControllerInterfaceResultToKotlin(getTrafficControllerInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficControllerInterface].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicenetworking&#46;kotlin&#46;inputs&#46;GetTrafficControllerInterfacePlainArgs].
     * @return Concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    public suspend
    fun getTrafficControllerInterface(argument: suspend GetTrafficControllerInterfacePlainArgsBuilder.() -> Unit):
        GetTrafficControllerInterfaceResult {
        val builder = GetTrafficControllerInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficControllerInterfaceResultToKotlin(getTrafficControllerInterfacePlain(builtArgument.toJava()).await())
    }
}
