@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.SignalRCustomCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A custom certificate.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### SignalRCustomCertificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalRCustomCertificate = new AzureNative.SignalRService.SignalRCustomCertificate("signalRCustomCertificate", new()
 *     {
 *         CertificateName = "myCert",
 *         KeyVaultBaseUri = "https://myvault.keyvault.azure.net/",
 *         KeyVaultSecretName = "mycert",
 *         KeyVaultSecretVersion = "bb6a44b2743f47f68dad0d6cc9756432",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signalrservice.NewSignalRCustomCertificate(ctx, "signalRCustomCertificate", &signalrservice.SignalRCustomCertificateArgs{
 * 			CertificateName:       pulumi.String("myCert"),
 * 			KeyVaultBaseUri:       pulumi.String("https://myvault.keyvault.azure.net/"),
 * 			KeyVaultSecretName:    pulumi.String("mycert"),
 * 			KeyVaultSecretVersion: pulumi.String("bb6a44b2743f47f68dad0d6cc9756432"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroup"),
 * 			ResourceName:          pulumi.String("mySignalRService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalRCustomCertificate;
 * import com.pulumi.azurenative.signalrservice.SignalRCustomCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalRCustomCertificate = new SignalRCustomCertificate("signalRCustomCertificate", SignalRCustomCertificateArgs.builder()
 *             .certificateName("myCert")
 *             .keyVaultBaseUri("https://myvault.keyvault.azure.net/")
 *             .keyVaultSecretName("mycert")
 *             .keyVaultSecretVersion("bb6a44b2743f47f68dad0d6cc9756432")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalRCustomCertificate myCert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}/customCertificates/{certificateName}
 * ```
 * @property certificateName Custom certificate name
 * @property keyVaultBaseUri Base uri of the KeyVault that stores certificate.
 * @property keyVaultSecretName Certificate secret name.
 * @property keyVaultSecretVersion Certificate secret version.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class SignalRCustomCertificateArgs(
    public val certificateName: Output<String>? = null,
    public val keyVaultBaseUri: Output<String>? = null,
    public val keyVaultSecretName: Output<String>? = null,
    public val keyVaultSecretVersion: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.SignalRCustomCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.SignalRCustomCertificateArgs =
        com.pulumi.azurenative.signalrservice.SignalRCustomCertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .keyVaultBaseUri(keyVaultBaseUri?.applyValue({ args0 -> args0 }))
            .keyVaultSecretName(keyVaultSecretName?.applyValue({ args0 -> args0 }))
            .keyVaultSecretVersion(keyVaultSecretVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SignalRCustomCertificateArgs].
 */
@PulumiTagMarker
public class SignalRCustomCertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var keyVaultBaseUri: Output<String>? = null

    private var keyVaultSecretName: Output<String>? = null

    private var keyVaultSecretVersion: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Custom certificate name
     */
    @JvmName("mrniiehgqacdiqvp")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Base uri of the KeyVault that stores certificate.
     */
    @JvmName("uyqbhtlremnbbweh")
    public suspend fun keyVaultBaseUri(`value`: Output<String>) {
        this.keyVaultBaseUri = value
    }

    /**
     * @param value Certificate secret name.
     */
    @JvmName("jgpmrtwlwjjqrwcp")
    public suspend fun keyVaultSecretName(`value`: Output<String>) {
        this.keyVaultSecretName = value
    }

    /**
     * @param value Certificate secret version.
     */
    @JvmName("lwjrqsotmpvvrucd")
    public suspend fun keyVaultSecretVersion(`value`: Output<String>) {
        this.keyVaultSecretVersion = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ahansohflncximnf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("nbpusriamwwdttmw")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Custom certificate name
     */
    @JvmName("hfygycdaxywnhufi")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Base uri of the KeyVault that stores certificate.
     */
    @JvmName("kwuqysfbsrykudgr")
    public suspend fun keyVaultBaseUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultBaseUri = mapped
    }

    /**
     * @param value Certificate secret name.
     */
    @JvmName("jvahhmwrhnyhnkdk")
    public suspend fun keyVaultSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretName = mapped
    }

    /**
     * @param value Certificate secret version.
     */
    @JvmName("njeblqiainkfincn")
    public suspend fun keyVaultSecretVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretVersion = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gsxyqllyfntahkmj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ogoqrxfnmrilkvks")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): SignalRCustomCertificateArgs = SignalRCustomCertificateArgs(
        certificateName = certificateName,
        keyVaultBaseUri = keyVaultBaseUri,
        keyVaultSecretName = keyVaultSecretName,
        keyVaultSecretVersion = keyVaultSecretVersion,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
