@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.SignalRCustomDomainArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A custom domain
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### SignalRCustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalRCustomDomain = new AzureNative.SignalRService.SignalRCustomDomain("signalRCustomDomain", new()
 *     {
 *         CustomCertificate = new AzureNative.SignalRService.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/SignalR/mySignalRService/customCertificates/myCert",
 *         },
 *         DomainName = "example.com",
 *         Name = "myDomain",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signalrservice.NewSignalRCustomDomain(ctx, "signalRCustomDomain", &signalrservice.SignalRCustomDomainArgs{
 * 			CustomCertificate: &signalrservice.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/SignalR/mySignalRService/customCertificates/myCert"),
 * 			},
 * 			DomainName:        pulumi.String("example.com"),
 * 			Name:              pulumi.String("myDomain"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("mySignalRService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalRCustomDomain;
 * import com.pulumi.azurenative.signalrservice.SignalRCustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalRCustomDomain = new SignalRCustomDomain("signalRCustomDomain", SignalRCustomDomainArgs.builder()
 *             .customCertificate(Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/SignalR/mySignalRService/customCertificates/myCert"))
 *             .domainName("example.com")
 *             .name("myDomain")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalRCustomDomain myDomain /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}/customDomains/{name}
 * ```
 * @property customCertificate Reference to a resource.
 * @property domainName The custom domain name.
 * @property name Custom domain name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class SignalRCustomDomainArgs(
    public val customCertificate: Output<ResourceReferenceArgs>? = null,
    public val domainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.SignalRCustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.SignalRCustomDomainArgs =
        com.pulumi.azurenative.signalrservice.SignalRCustomDomainArgs.builder()
            .customCertificate(customCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SignalRCustomDomainArgs].
 */
@PulumiTagMarker
public class SignalRCustomDomainArgsBuilder internal constructor() {
    private var customCertificate: Output<ResourceReferenceArgs>? = null

    private var domainName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Reference to a resource.
     */
    @JvmName("pritfyyikuabcbhy")
    public suspend fun customCertificate(`value`: Output<ResourceReferenceArgs>) {
        this.customCertificate = value
    }

    /**
     * @param value The custom domain name.
     */
    @JvmName("tsesptxvreslchtu")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Custom domain name.
     */
    @JvmName("xnhiunbqwkahgjsc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hoqeqtrmuswgnuii")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("pmxbhpjjhdpsttbp")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Reference to a resource.
     */
    @JvmName("xapsajaaixjxrysi")
    public suspend fun customCertificate(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCertificate = mapped
    }

    /**
     * @param argument Reference to a resource.
     */
    @JvmName("nhalravwbloktjin")
    public suspend fun customCertificate(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customCertificate = mapped
    }

    /**
     * @param value The custom domain name.
     */
    @JvmName("cdgggcekhqgskkmy")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Custom domain name.
     */
    @JvmName("tybgmjvqekkdjwym")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qjoypkiprnmnkxok")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("xmpjlvulsavhhvwc")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): SignalRCustomDomainArgs = SignalRCustomDomainArgs(
        customCertificate = customCertificate,
        domainName = domainName,
        name = name,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
