@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.SignalRSharedPrivateLinkResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a Shared Private Link Resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### SignalRSharedPrivateLinkResources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalRSharedPrivateLinkResource = new AzureNative.SignalRService.SignalRSharedPrivateLinkResource("signalRSharedPrivateLinkResource", new()
 *     {
 *         GroupId = "sites",
 *         PrivateLinkResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Web/sites/myWebApp",
 *         RequestMessage = "Please approve",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *         SharedPrivateLinkResourceName = "upstream",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signalrservice.NewSignalRSharedPrivateLinkResource(ctx, "signalRSharedPrivateLinkResource", &signalrservice.SignalRSharedPrivateLinkResourceArgs{
 * 			GroupId:                       pulumi.String("sites"),
 * 			PrivateLinkResourceId:         pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Web/sites/myWebApp"),
 * 			RequestMessage:                pulumi.String("Please approve"),
 * 			ResourceGroupName:             pulumi.String("myResourceGroup"),
 * 			ResourceName:                  pulumi.String("mySignalRService"),
 * 			SharedPrivateLinkResourceName: pulumi.String("upstream"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalRSharedPrivateLinkResource;
 * import com.pulumi.azurenative.signalrservice.SignalRSharedPrivateLinkResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalRSharedPrivateLinkResource = new SignalRSharedPrivateLinkResource("signalRSharedPrivateLinkResource", SignalRSharedPrivateLinkResourceArgs.builder()
 *             .groupId("sites")
 *             .privateLinkResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Web/sites/myWebApp")
 *             .requestMessage("Please approve")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .sharedPrivateLinkResourceName("upstream")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalRSharedPrivateLinkResource upstream /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}
 * ```
 * @property groupId The group id from the provider of resource the shared private link resource is for
 * @property privateLinkResourceId The resource id of the resource the shared private link resource is for
 * @property requestMessage The request message for requesting approval of the shared private link resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 * @property sharedPrivateLinkResourceName The name of the shared private link resource
 */
public data class SignalRSharedPrivateLinkResourceArgs(
    public val groupId: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sharedPrivateLinkResourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.SignalRSharedPrivateLinkResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.SignalRSharedPrivateLinkResourceArgs =
        com.pulumi.azurenative.signalrservice.SignalRSharedPrivateLinkResourceArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sharedPrivateLinkResourceName(
                sharedPrivateLinkResourceName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SignalRSharedPrivateLinkResourceArgs].
 */
@PulumiTagMarker
public class SignalRSharedPrivateLinkResourceArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var requestMessage: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sharedPrivateLinkResourceName: Output<String>? = null

    /**
     * @param value The group id from the provider of resource the shared private link resource is for
     */
    @JvmName("rwqoguwnjiygfist")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for
     */
    @JvmName("eexnxevhxriojybu")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource
     */
    @JvmName("sufbnrvwijkdwnou")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lxisfkfsejkxdttf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("aehppkangsgttqhv")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the shared private link resource
     */
    @JvmName("ngjcqwastcvmxuvk")
    public suspend fun sharedPrivateLinkResourceName(`value`: Output<String>) {
        this.sharedPrivateLinkResourceName = value
    }

    /**
     * @param value The group id from the provider of resource the shared private link resource is for
     */
    @JvmName("bohdwybxmaxicvkt")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for
     */
    @JvmName("cvxibmgklddxkrab")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource
     */
    @JvmName("ggxisutkvkuxtkpj")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xfsjiaywbjsjqbvw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("qxevwatfuytnbtdt")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The name of the shared private link resource
     */
    @JvmName("iypnqgitumpyjxbo")
    public suspend fun sharedPrivateLinkResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPrivateLinkResourceName = mapped
    }

    internal fun build(): SignalRSharedPrivateLinkResourceArgs = SignalRSharedPrivateLinkResourceArgs(
        groupId = groupId,
        privateLinkResourceId = privateLinkResourceId,
        requestMessage = requestMessage,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sharedPrivateLinkResourceName = sharedPrivateLinkResourceName,
    )
}
