@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.ManagedIdentityArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.ManagedIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A class represent managed identities used for request and response
 * @property type Represents the identity type: systemAssigned, userAssigned, None
 * @property userAssignedIdentities Get or set the user assigned identities
 */
public data class ManagedIdentityArgs(
    public val type: Output<Either<String, ManagedIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.ManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.ManagedIdentityArgs =
        com.pulumi.azurenative.signalrservice.inputs.ManagedIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedIdentityArgs].
 */
@PulumiTagMarker
public class ManagedIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Represents the identity type: systemAssigned, userAssigned, None
     */
    @JvmName("ntsmeqwmjrosawim")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Get or set the user assigned identities
     */
    @JvmName("wlqvcdywmswgvghs")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("xapyrtruqkugnyvb")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Get or set the user assigned identities
     */
    @JvmName("ndgsoxclqyqejqna")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Represents the identity type: systemAssigned, userAssigned, None
     */
    @JvmName("ehbxbmvgndvxdktk")
    public suspend fun type(`value`: Either<String, ManagedIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Represents the identity type: systemAssigned, userAssigned, None
     */
    @JvmName("sofqfpvmmaycosnw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Represents the identity type: systemAssigned, userAssigned, None
     */
    @JvmName("wklbhpwqjeamiewj")
    public fun type(`value`: ManagedIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Get or set the user assigned identities
     */
    @JvmName("bkrcvnxyfuftaent")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Get or set the user assigned identities
     */
    @JvmName("mxmisuytsohsbcdd")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ManagedIdentityArgs = ManagedIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
