@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.NetworkACLArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.SignalRRequestType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network ACL
 * @property allow Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property deny Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 */
public data class NetworkACLArgs(
    public val allow: Output<List<Either<String, SignalRRequestType>>>? = null,
    public val deny: Output<List<Either<String, SignalRRequestType>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.NetworkACLArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.NetworkACLArgs =
        com.pulumi.azurenative.signalrservice.inputs.NetworkACLArgs.builder()
            .allow(
                allow?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .deny(
                deny?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkACLArgs].
 */
@PulumiTagMarker
public class NetworkACLArgsBuilder internal constructor() {
    private var allow: Output<List<Either<String, SignalRRequestType>>>? = null

    private var deny: Output<List<Either<String, SignalRRequestType>>>? = null

    /**
     * @param value Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("qslqruasqeredbtm")
    public suspend fun allow(`value`: Output<List<Either<String, SignalRRequestType>>>) {
        this.allow = value
    }

    @JvmName("qukofbncernjwcwq")
    public suspend fun allow(vararg values: Output<Either<String, SignalRRequestType>>) {
        this.allow = Output.all(values.asList())
    }

    /**
     * @param values Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("mqfsrnymtsrwdolu")
    public suspend fun allow(values: List<Output<Either<String, SignalRRequestType>>>) {
        this.allow = Output.all(values)
    }

    /**
     * @param value Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("hhjsuqfmkddrayxp")
    public suspend fun deny(`value`: Output<List<Either<String, SignalRRequestType>>>) {
        this.deny = value
    }

    @JvmName("juxeafbfcrbnclce")
    public suspend fun deny(vararg values: Output<Either<String, SignalRRequestType>>) {
        this.deny = Output.all(values.asList())
    }

    /**
     * @param values Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("iumcsatvqowdrehp")
    public suspend fun deny(values: List<Output<Either<String, SignalRRequestType>>>) {
        this.deny = Output.all(values)
    }

    /**
     * @param value Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("frmtvawkqbpnqgno")
    public suspend fun allow(`value`: List<Either<String, SignalRRequestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param values Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("devkejsakvrvndpi")
    public suspend fun allow(vararg values: Either<String, SignalRRequestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param value Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("msbvoksoaluusxhv")
    public suspend fun deny(`value`: List<Either<String, SignalRRequestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deny = mapped
    }

    /**
     * @param values Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("rbylwwqywitxtuer")
    public suspend fun deny(vararg values: Either<String, SignalRRequestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deny = mapped
    }

    internal fun build(): NetworkACLArgs = NetworkACLArgs(
        allow = allow,
        deny = deny,
    )
}
