@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.SignalRCorsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cross-Origin Resource Sharing (CORS) settings.
 * @property allowedOrigins Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
 */
public data class SignalRCorsSettingsArgs(
    public val allowedOrigins: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.SignalRCorsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.SignalRCorsSettingsArgs =
        com.pulumi.azurenative.signalrservice.inputs.SignalRCorsSettingsArgs.builder()
            .allowedOrigins(allowedOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SignalRCorsSettingsArgs].
 */
@PulumiTagMarker
public class SignalRCorsSettingsArgsBuilder internal constructor() {
    private var allowedOrigins: Output<List<String>>? = null

    /**
     * @param value Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
     */
    @JvmName("wpgxnwkmhgcghqhq")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("vepqajlfibmahdxv")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
     */
    @JvmName("tdvwbsjrtxwonghw")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
     */
    @JvmName("mdkffewvhjblewfn")
    public suspend fun allowedOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
     */
    @JvmName("uptsapumwjqlwgos")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    internal fun build(): SignalRCorsSettingsArgs = SignalRCorsSettingsArgs(
        allowedOrigins = allowedOrigins,
    )
}
