@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.SignalRFeatureArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.FeatureFlags
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Feature of a resource, which controls the runtime behavior.
 * @property flag FeatureFlags is the supported features of Azure SignalR service.
 * - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
 * - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
 * - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
 * - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
 * @property properties Optional properties related to this feature.
 * @property value Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
 */
public data class SignalRFeatureArgs(
    public val flag: Output<Either<String, FeatureFlags>>,
    public val properties: Output<Map<String, String>>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.SignalRFeatureArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.SignalRFeatureArgs =
        com.pulumi.azurenative.signalrservice.inputs.SignalRFeatureArgs.builder()
            .flag(
                flag.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SignalRFeatureArgs].
 */
@PulumiTagMarker
public class SignalRFeatureArgsBuilder internal constructor() {
    private var flag: Output<Either<String, FeatureFlags>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value FeatureFlags is the supported features of Azure SignalR service.
     * - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
     * - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
     */
    @JvmName("xcfqvohlaacxdmnj")
    public suspend fun flag(`value`: Output<Either<String, FeatureFlags>>) {
        this.flag = value
    }

    /**
     * @param value Optional properties related to this feature.
     */
    @JvmName("yvsxbwnybefjtoak")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
     */
    @JvmName("estwdaxwibabbddg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value FeatureFlags is the supported features of Azure SignalR service.
     * - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
     * - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
     */
    @JvmName("yhectybbpbxlphse")
    public suspend fun flag(`value`: Either<String, FeatureFlags>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flag = mapped
    }

    /**
     * @param value FeatureFlags is the supported features of Azure SignalR service.
     * - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
     * - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
     */
    @JvmName("wxuscbuydtajfqiu")
    public fun flag(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeatureFlags>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flag = mapped
    }

    /**
     * @param value FeatureFlags is the supported features of Azure SignalR service.
     * - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
     * - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
     * - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
     */
    @JvmName("vgxlusndxjajnmhy")
    public fun flag(`value`: FeatureFlags) {
        val toBeMapped = Either.ofRight<String, FeatureFlags>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flag = mapped
    }

    /**
     * @param value Optional properties related to this feature.
     */
    @JvmName("fspkegugaxhvjklc")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Optional properties related to this feature.
     */
    @JvmName("rtostyupxlivhiyf")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
     */
    @JvmName("haleivnixckkqcgi")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SignalRFeatureArgs = SignalRFeatureArgs(
        flag = flag ?: throw PulumiNullFieldException("flag"),
        properties = properties,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
