@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.SignalRNetworkACLsArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.ACLAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network ACLs for the resource
 * @property defaultAction Azure Networking ACL Action.
 * @property privateEndpoints ACLs for requests from private endpoints
 * @property publicNetwork Network ACL
 */
public data class SignalRNetworkACLsArgs(
    public val defaultAction: Output<Either<String, ACLAction>>? = null,
    public val privateEndpoints: Output<List<PrivateEndpointACLArgs>>? = null,
    public val publicNetwork: Output<NetworkACLArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.SignalRNetworkACLsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.SignalRNetworkACLsArgs =
        com.pulumi.azurenative.signalrservice.inputs.SignalRNetworkACLsArgs.builder()
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateEndpoints(
                privateEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicNetwork(publicNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SignalRNetworkACLsArgs].
 */
@PulumiTagMarker
public class SignalRNetworkACLsArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, ACLAction>>? = null

    private var privateEndpoints: Output<List<PrivateEndpointACLArgs>>? = null

    private var publicNetwork: Output<NetworkACLArgs>? = null

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("tvpmbtvinhuxgtit")
    public suspend fun defaultAction(`value`: Output<Either<String, ACLAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value ACLs for requests from private endpoints
     */
    @JvmName("virhngnjxbxiyfwx")
    public suspend fun privateEndpoints(`value`: Output<List<PrivateEndpointACLArgs>>) {
        this.privateEndpoints = value
    }

    @JvmName("lkpqfoqfmovckcjb")
    public suspend fun privateEndpoints(vararg values: Output<PrivateEndpointACLArgs>) {
        this.privateEndpoints = Output.all(values.asList())
    }

    /**
     * @param values ACLs for requests from private endpoints
     */
    @JvmName("pnmwgimbdtiyafhc")
    public suspend fun privateEndpoints(values: List<Output<PrivateEndpointACLArgs>>) {
        this.privateEndpoints = Output.all(values)
    }

    /**
     * @param value Network ACL
     */
    @JvmName("mfhijauejjphgpht")
    public suspend fun publicNetwork(`value`: Output<NetworkACLArgs>) {
        this.publicNetwork = value
    }

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("gphhluaujsprmfov")
    public suspend fun defaultAction(`value`: Either<String, ACLAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("pxrmmuqajnabcotr")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ACLAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Azure Networking ACL Action.
     */
    @JvmName("ihdsoujodglxelsx")
    public fun defaultAction(`value`: ACLAction) {
        val toBeMapped = Either.ofRight<String, ACLAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value ACLs for requests from private endpoints
     */
    @JvmName("wckwcotfolihyesv")
    public suspend fun privateEndpoints(`value`: List<PrivateEndpointACLArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoints = mapped
    }

    /**
     * @param argument ACLs for requests from private endpoints
     */
    @JvmName("khtavquksukdwxbh")
    public suspend
    fun privateEndpoints(argument: List<suspend PrivateEndpointACLArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointACLArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpoints = mapped
    }

    /**
     * @param argument ACLs for requests from private endpoints
     */
    @JvmName("qahpmxglahftapyb")
    public suspend fun privateEndpoints(
        vararg
        argument: suspend PrivateEndpointACLArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointACLArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpoints = mapped
    }

    /**
     * @param argument ACLs for requests from private endpoints
     */
    @JvmName("hqhfwvmnhgoexcyi")
    public suspend fun privateEndpoints(argument: suspend PrivateEndpointACLArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrivateEndpointACLArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.privateEndpoints = mapped
    }

    /**
     * @param values ACLs for requests from private endpoints
     */
    @JvmName("bgahwhoousvdteki")
    public suspend fun privateEndpoints(vararg values: PrivateEndpointACLArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpoints = mapped
    }

    /**
     * @param value Network ACL
     */
    @JvmName("bkkejhuqexxyoarv")
    public suspend fun publicNetwork(`value`: NetworkACLArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetwork = mapped
    }

    /**
     * @param argument Network ACL
     */
    @JvmName("kwlgeyusrrwxjabw")
    public suspend fun publicNetwork(argument: suspend NetworkACLArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkACLArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicNetwork = mapped
    }

    internal fun build(): SignalRNetworkACLsArgs = SignalRNetworkACLsArgs(
        defaultAction = defaultAction,
        privateEndpoints = privateEndpoints,
        publicNetwork = publicNetwork,
    )
}
