@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.SignalRTlsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * TLS settings for the resource
 * @property clientCertEnabled Request client certificate during TLS handshake if enabled
 */
public data class SignalRTlsSettingsArgs(
    public val clientCertEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.SignalRTlsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.SignalRTlsSettingsArgs =
        com.pulumi.azurenative.signalrservice.inputs.SignalRTlsSettingsArgs.builder()
            .clientCertEnabled(clientCertEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SignalRTlsSettingsArgs].
 */
@PulumiTagMarker
public class SignalRTlsSettingsArgsBuilder internal constructor() {
    private var clientCertEnabled: Output<Boolean>? = null

    /**
     * @param value Request client certificate during TLS handshake if enabled
     */
    @JvmName("wdugworoddatctnl")
    public suspend fun clientCertEnabled(`value`: Output<Boolean>) {
        this.clientCertEnabled = value
    }

    /**
     * @param value Request client certificate during TLS handshake if enabled
     */
    @JvmName("aadkryytpxojnyqv")
    public suspend fun clientCertEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertEnabled = mapped
    }

    internal fun build(): SignalRTlsSettingsArgs = SignalRTlsSettingsArgs(
        clientCertEnabled = clientCertEnabled,
    )
}
