@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ACL for a private endpoint
 * @property allow Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property deny Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property name Name of the private endpoint connection
 */
public data class PrivateEndpointACLResponse(
    public val allow: List<String>? = null,
    public val deny: List<String>? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.PrivateEndpointACLResponse):
            PrivateEndpointACLResponse = PrivateEndpointACLResponse(
            allow = javaType.allow().map({ args0 -> args0 }),
            deny = javaType.deny().map({ args0 -> args0 }),
            name = javaType.name(),
        )
    }
}
