@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Serverless settings.
 * @property connectionTimeoutInSeconds Gets or sets Client Connection Timeout. Optional to be set.
 * Value in seconds.
 * Default value is 30 seconds.
 * Customer should set the timeout to a shorter period if messages are expected to be sent in shorter intervals,
 * and want the client to disconnect more quickly after the last message is sent.
 * You can set the timeout to a longer period if messages are expected to be sent in longer intervals,
 * and they want to keep the same client connection alive during this session.
 * The service considers the client disconnected if it hasn't received a message (including keep-alive) in this interval.
 */
public data class ServerlessSettingsResponse(
    public val connectionTimeoutInSeconds: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.ServerlessSettingsResponse):
            ServerlessSettingsResponse = ServerlessSettingsResponse(
            connectionTimeoutInSeconds = javaType.connectionTimeoutInSeconds().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
