@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.softwareplan.kotlin

import com.pulumi.azurenative.softwareplan.HybridUseBenefitArgs.builder
import com.pulumi.azurenative.softwareplan.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.softwareplan.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Response on GET of a hybrid use benefit
 * Azure REST API version: 2019-12-01. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### HybridUseBenefit
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridUseBenefit = new AzureNative.SoftwarePlan.HybridUseBenefit("hybridUseBenefit", new()
 *     {
 *         PlanId = "94f46eda-45f8-493a-8425-251921463a89",
 *         Scope = "subscriptions/{sub-id}/resourceGroups/{rg-name}/providers/Microsoft.Compute/HostGroups/{host-group-name}/hosts/{host-name}",
 *         Sku = new AzureNative.SoftwarePlan.Inputs.SkuArgs
 *         {
 *             Name = "SQL_Server_Perpetual",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/softwareplan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := softwareplan.NewHybridUseBenefit(ctx, "hybridUseBenefit", &softwareplan.HybridUseBenefitArgs{
 * 			PlanId: pulumi.String("94f46eda-45f8-493a-8425-251921463a89"),
 * 			Scope:  pulumi.String("subscriptions/{sub-id}/resourceGroups/{rg-name}/providers/Microsoft.Compute/HostGroups/{host-group-name}/hosts/{host-name}"),
 * 			Sku: &softwareplan.SkuArgs{
 * 				Name: pulumi.String("SQL_Server_Perpetual"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.softwareplan.HybridUseBenefit;
 * import com.pulumi.azurenative.softwareplan.HybridUseBenefitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridUseBenefit = new HybridUseBenefit("hybridUseBenefit", HybridUseBenefitArgs.builder()
 *             .planId("94f46eda-45f8-493a-8425-251921463a89")
 *             .scope("subscriptions/{sub-id}/resourceGroups/{rg-name}/providers/Microsoft.Compute/HostGroups/{host-group-name}/hosts/{host-name}")
 *             .sku(Map.of("name", "SQL_Server_Perpetual"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:softwareplan:HybridUseBenefit SQL_{hostGroupName}_{hostName} /{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}
 * ```
 * @property planId This is a unique identifier for a plan. Should be a guid.
 * @property scope The scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines and Microsoft.Compute/hostGroups/hosts for now
 * @property sku Hybrid use benefit SKU
 */
public data class HybridUseBenefitArgs(
    public val planId: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.softwareplan.HybridUseBenefitArgs> {
    override fun toJava(): com.pulumi.azurenative.softwareplan.HybridUseBenefitArgs =
        com.pulumi.azurenative.softwareplan.HybridUseBenefitArgs.builder()
            .planId(planId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HybridUseBenefitArgs].
 */
@PulumiTagMarker
public class HybridUseBenefitArgsBuilder internal constructor() {
    private var planId: Output<String>? = null

    private var scope: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value This is a unique identifier for a plan. Should be a guid.
     */
    @JvmName("gpkmfbhrgpdijffb")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value The scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines and Microsoft.Compute/hostGroups/hosts for now
     */
    @JvmName("fymabvrmhityxyen")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Hybrid use benefit SKU
     */
    @JvmName("iqiggpwywmguywjy")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value This is a unique identifier for a plan. Should be a guid.
     */
    @JvmName("ovjouqxjgqbheeej")
    public suspend fun planId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value The scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines and Microsoft.Compute/hostGroups/hosts for now
     */
    @JvmName("jltxdeljtwomquhu")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Hybrid use benefit SKU
     */
    @JvmName("uhkuopnigplpqgqo")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Hybrid use benefit SKU
     */
    @JvmName("rocbwifcuksxsmuf")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): HybridUseBenefitArgs = HybridUseBenefitArgs(
        planId = planId,
        scope = scope,
        sku = sku,
    )
}
