@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.ApplicationArgs.builder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationJitAccessPolicyArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationJitAccessPolicyArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about managed application.
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2017-12-01, 2018-06-01.
 * ## Example Usage
 * ### Create or update managed application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.Solutions.Application("application", new()
 *     {
 *         ApplicationDefinitionId = "/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef",
 *         ApplicationName = "myManagedApplication",
 *         Kind = "ServiceCatalog",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/solutions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := solutions.NewApplication(ctx, "application", &solutions.ApplicationArgs{
 * 			ApplicationDefinitionId: pulumi.String("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef"),
 * 			ApplicationName:         pulumi.String("myManagedApplication"),
 * 			Kind:                    pulumi.String("ServiceCatalog"),
 * 			ManagedResourceGroupId:  pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			ResourceGroupName:       pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.solutions.Application;
 * import com.pulumi.azurenative.solutions.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationDefinitionId("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef")
 *             .applicationName("myManagedApplication")
 *             .kind("ServiceCatalog")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:solutions:Application myManagedApplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications/{applicationName}
 * ```
 * @property applicationDefinitionId The fully qualified path of managed application definition Id.
 * @property applicationName The name of the managed application.
 * @property identity The identity of the resource.
 * @property jitAccessPolicy The managed application Jit access policy.
 * @property kind The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
 * @property location Resource location
 * @property managedBy ID of the resource that manages this resource.
 * @property managedResourceGroupId The managed resource group Id.
 * @property parameters Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
 * @property plan The plan information.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of the resource.
 * @property tags Resource tags
 */
public data class ApplicationArgs(
    public val applicationDefinitionId: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val jitAccessPolicy: Output<ApplicationJitAccessPolicyArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val managedResourceGroupId: Output<String>? = null,
    public val parameters: Output<Any>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.ApplicationArgs =
        com.pulumi.azurenative.solutions.ApplicationArgs.builder()
            .applicationDefinitionId(applicationDefinitionId?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jitAccessPolicy(jitAccessPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .managedResourceGroupId(managedResourceGroupId?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationDefinitionId: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var jitAccessPolicy: Output<ApplicationJitAccessPolicyArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var managedResourceGroupId: Output<String>? = null

    private var parameters: Output<Any>? = null

    private var plan: Output<PlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The fully qualified path of managed application definition Id.
     */
    @JvmName("woqytxvmadhahegp")
    public suspend fun applicationDefinitionId(`value`: Output<String>) {
        this.applicationDefinitionId = value
    }

    /**
     * @param value The name of the managed application.
     */
    @JvmName("fhoxyjroadynsuwv")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("xuutuyxvxhyshrsh")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The managed application Jit access policy.
     */
    @JvmName("hdvxfyjtrmhhqvuq")
    public suspend fun jitAccessPolicy(`value`: Output<ApplicationJitAccessPolicyArgs>) {
        this.jitAccessPolicy = value
    }

    /**
     * @param value The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
     */
    @JvmName("yobpjbrrttgkbmhf")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("cnxxybrbnqtksonj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ID of the resource that manages this resource.
     */
    @JvmName("gyqjvapvrjshswio")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value The managed resource group Id.
     */
    @JvmName("ejrhshxpkafhterf")
    public suspend fun managedResourceGroupId(`value`: Output<String>) {
        this.managedResourceGroupId = value
    }

    /**
     * @param value Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
     */
    @JvmName("kdnsrfgovrmkcfbh")
    public suspend fun parameters(`value`: Output<Any>) {
        this.parameters = value
    }

    /**
     * @param value The plan information.
     */
    @JvmName("jphjxwoclrmoseny")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tcljrkbnromjxhji")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("ysqrkmwlqpaqbtsn")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ygsasaadkupwbduo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The fully qualified path of managed application definition Id.
     */
    @JvmName("qanlgldrpnifrkad")
    public suspend fun applicationDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationDefinitionId = mapped
    }

    /**
     * @param value The name of the managed application.
     */
    @JvmName("usuqhwoeuktrtrlv")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("hlgubdsmtseqdams")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("qqnwhuqarrcedesg")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The managed application Jit access policy.
     */
    @JvmName("shaofydumseobpuo")
    public suspend fun jitAccessPolicy(`value`: ApplicationJitAccessPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitAccessPolicy = mapped
    }

    /**
     * @param argument The managed application Jit access policy.
     */
    @JvmName("kfkwjwvhtteaerpr")
    public suspend
    fun jitAccessPolicy(argument: suspend ApplicationJitAccessPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationJitAccessPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jitAccessPolicy = mapped
    }

    /**
     * @param value The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
     */
    @JvmName("mdnqqvhrsiacaeql")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("qijfmssjvfgebmxa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ID of the resource that manages this resource.
     */
    @JvmName("wecivjqhpkydniqg")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value The managed resource group Id.
     */
    @JvmName("srooksdeixqykjgy")
    public suspend fun managedResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupId = mapped
    }

    /**
     * @param value Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
     */
    @JvmName("ywssicobnhksjjjp")
    public suspend fun parameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The plan information.
     */
    @JvmName("sjfvfrfcryrdycqu")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument The plan information.
     */
    @JvmName("hjwdtrqvbjirhkrq")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lqielejhclqlnnnn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("xgxtmcykrtcwlnxn")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the resource.
     */
    @JvmName("djldyjspwspndgkn")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("mcjjlcormejsrcgr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("sopgkpurexrxiwir")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationDefinitionId = applicationDefinitionId,
        applicationName = applicationName,
        identity = identity,
        jitAccessPolicy = jitAccessPolicy,
        kind = kind,
        location = location,
        managedBy = managedBy,
        managedResourceGroupId = managedResourceGroupId,
        parameters = parameters,
        plan = plan,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
