@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.SolutionsFunctions.getApplicationDefinitionPlain
import com.pulumi.azurenative.solutions.SolutionsFunctions.getApplicationPlain
import com.pulumi.azurenative.solutions.SolutionsFunctions.getJitRequestPlain
import com.pulumi.azurenative.solutions.SolutionsFunctions.listApplicationAllowedUpgradePlansPlain
import com.pulumi.azurenative.solutions.SolutionsFunctions.listApplicationTokensPlain
import com.pulumi.azurenative.solutions.kotlin.inputs.GetApplicationDefinitionPlainArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.GetApplicationDefinitionPlainArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.GetJitRequestPlainArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.GetJitRequestPlainArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ListApplicationAllowedUpgradePlansPlainArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ListApplicationAllowedUpgradePlansPlainArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ListApplicationTokensPlainArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ListApplicationTokensPlainArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.outputs.GetApplicationDefinitionResult
import com.pulumi.azurenative.solutions.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.solutions.kotlin.outputs.GetJitRequestResult
import com.pulumi.azurenative.solutions.kotlin.outputs.ListApplicationAllowedUpgradePlansResult
import com.pulumi.azurenative.solutions.kotlin.outputs.ListApplicationTokensResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.solutions.kotlin.outputs.GetApplicationDefinitionResult.Companion.toKotlin as getApplicationDefinitionResultToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.GetJitRequestResult.Companion.toKotlin as getJitRequestResultToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ListApplicationAllowedUpgradePlansResult.Companion.toKotlin as listApplicationAllowedUpgradePlansResultToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ListApplicationTokensResult.Companion.toKotlin as listApplicationTokensResultToKotlin

public object SolutionsFunctions {
    /**
     * Gets the managed application.
     * Azure REST API version: 2021-07-01.
     * Other available API versions: 2017-12-01, 2018-06-01.
     * @param argument null
     * @return Information about managed application.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationName The name of the managed application.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Information about managed application.
     */
    public suspend fun getApplication(applicationName: String, resourceGroupName: String):
        GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;solutions&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return Information about managed application.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit):
        GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the managed application definition.
     * Azure REST API version: 2021-07-01.
     * Other available API versions: 2017-12-01.
     * @param argument null
     * @return Information about managed application definition.
     */
    public suspend fun getApplicationDefinition(argument: GetApplicationDefinitionPlainArgs):
        GetApplicationDefinitionResult =
        getApplicationDefinitionResultToKotlin(getApplicationDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getApplicationDefinition].
     * @param applicationDefinitionName The name of the managed application definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Information about managed application definition.
     */
    public suspend fun getApplicationDefinition(
        applicationDefinitionName: String,
        resourceGroupName: String,
    ): GetApplicationDefinitionResult {
        val argument = GetApplicationDefinitionPlainArgs(
            applicationDefinitionName = applicationDefinitionName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationDefinitionResultToKotlin(getApplicationDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;solutions&#46;kotlin&#46;inputs&#46;GetApplicationDefinitionPlainArgs].
     * @return Information about managed application definition.
     */
    public suspend
    fun getApplicationDefinition(argument: suspend GetApplicationDefinitionPlainArgsBuilder.() -> Unit):
        GetApplicationDefinitionResult {
        val builder = GetApplicationDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationDefinitionResultToKotlin(getApplicationDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the JIT request.
     * Azure REST API version: 2021-07-01.
     * @param argument null
     * @return Information about JIT request definition.
     */
    public suspend fun getJitRequest(argument: GetJitRequestPlainArgs): GetJitRequestResult =
        getJitRequestResultToKotlin(getJitRequestPlain(argument.toJava()).await())

    /**
     * @see [getJitRequest].
     * @param jitRequestName The name of the JIT request.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Information about JIT request definition.
     */
    public suspend fun getJitRequest(jitRequestName: String, resourceGroupName: String):
        GetJitRequestResult {
        val argument = GetJitRequestPlainArgs(
            jitRequestName = jitRequestName,
            resourceGroupName = resourceGroupName,
        )
        return getJitRequestResultToKotlin(getJitRequestPlain(argument.toJava()).await())
    }

    /**
     * @see [getJitRequest].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;solutions&#46;kotlin&#46;inputs&#46;GetJitRequestPlainArgs].
     * @return Information about JIT request definition.
     */
    public suspend fun getJitRequest(argument: suspend GetJitRequestPlainArgsBuilder.() -> Unit):
        GetJitRequestResult {
        val builder = GetJitRequestPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJitRequestResultToKotlin(getJitRequestPlain(builtArgument.toJava()).await())
    }

    /**
     * List allowed upgrade plans for application.
     * Azure REST API version: 2021-07-01.
     * @param argument null
     * @return The array of plan.
     */
    public suspend
    fun listApplicationAllowedUpgradePlans(argument: ListApplicationAllowedUpgradePlansPlainArgs):
        ListApplicationAllowedUpgradePlansResult =
        listApplicationAllowedUpgradePlansResultToKotlin(listApplicationAllowedUpgradePlansPlain(argument.toJava()).await())

    /**
     * @see [listApplicationAllowedUpgradePlans].
     * @param applicationName The name of the managed application.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The array of plan.
     */
    public suspend fun listApplicationAllowedUpgradePlans(
        applicationName: String,
        resourceGroupName: String,
    ): ListApplicationAllowedUpgradePlansResult {
        val argument = ListApplicationAllowedUpgradePlansPlainArgs(
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
        )
        return listApplicationAllowedUpgradePlansResultToKotlin(listApplicationAllowedUpgradePlansPlain(argument.toJava()).await())
    }

    /**
     * @see [listApplicationAllowedUpgradePlans].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;solutions&#46;kotlin&#46;inputs&#46;ListApplicationAllowedUpgradePlansPlainArgs].
     * @return The array of plan.
     */
    public suspend
    fun listApplicationAllowedUpgradePlans(argument: suspend ListApplicationAllowedUpgradePlansPlainArgsBuilder.() -> Unit):
        ListApplicationAllowedUpgradePlansResult {
        val builder = ListApplicationAllowedUpgradePlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApplicationAllowedUpgradePlansResultToKotlin(listApplicationAllowedUpgradePlansPlain(builtArgument.toJava()).await())
    }

    /**
     * List tokens for application.
     * Azure REST API version: 2021-07-01.
     * Other available API versions: 2018-06-01.
     * @param argument null
     * @return The array of managed identity tokens.
     */
    public suspend fun listApplicationTokens(argument: ListApplicationTokensPlainArgs):
        ListApplicationTokensResult =
        listApplicationTokensResultToKotlin(listApplicationTokensPlain(argument.toJava()).await())

    /**
     * @see [listApplicationTokens].
     * @param applicationName The name of the managed application.
     * @param authorizationAudience The authorization audience.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param userAssignedIdentities The user assigned identities.
     * @return The array of managed identity tokens.
     */
    public suspend fun listApplicationTokens(
        applicationName: String,
        authorizationAudience: String? = null,
        resourceGroupName: String,
        userAssignedIdentities: List<String>? = null,
    ): ListApplicationTokensResult {
        val argument = ListApplicationTokensPlainArgs(
            applicationName = applicationName,
            authorizationAudience = authorizationAudience,
            resourceGroupName = resourceGroupName,
            userAssignedIdentities = userAssignedIdentities,
        )
        return listApplicationTokensResultToKotlin(listApplicationTokensPlain(argument.toJava()).await())
    }

    /**
     * @see [listApplicationTokens].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;solutions&#46;kotlin&#46;inputs&#46;ListApplicationTokensPlainArgs].
     * @return The array of managed identity tokens.
     */
    public suspend
    fun listApplicationTokens(argument: suspend ListApplicationTokensPlainArgsBuilder.() -> Unit):
        ListApplicationTokensResult {
        val builder = ListApplicationTokensPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApplicationTokensResultToKotlin(listApplicationTokensPlain(builtArgument.toJava()).await())
    }
}
