@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.JitSchedulingPolicyArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.JitSchedulingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The JIT scheduling policies.
 * @property duration
 * @property startTime The start time of the request.
 * @property type The type of JIT schedule.
 */
public data class JitSchedulingPolicyArgs(
    public val duration: Output<String>,
    public val startTime: Output<String>,
    public val type: Output<Either<String, JitSchedulingType>>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.JitSchedulingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.JitSchedulingPolicyArgs =
        com.pulumi.azurenative.solutions.inputs.JitSchedulingPolicyArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .startTime(startTime.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitSchedulingPolicyArgs].
 */
@PulumiTagMarker
public class JitSchedulingPolicyArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var startTime: Output<String>? = null

    private var type: Output<Either<String, JitSchedulingType>>? = null

    /**
     * @param value
     */
    @JvmName("ptyykhjubmnsulnb")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The start time of the request.
     */
    @JvmName("xcdqnwhhuyqboaku")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The type of JIT schedule.
     */
    @JvmName("nqxsmpxsqtgwscrk")
    public suspend fun type(`value`: Output<Either<String, JitSchedulingType>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("prirjrgdlyaduass")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The start time of the request.
     */
    @JvmName("flmkasduprffjcsp")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The type of JIT schedule.
     */
    @JvmName("nnyftoegueybxrri")
    public suspend fun type(`value`: Either<String, JitSchedulingType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of JIT schedule.
     */
    @JvmName("hglcaawociekqwep")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JitSchedulingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of JIT schedule.
     */
    @JvmName("bxjdcsciwmopnkhx")
    public fun type(`value`: JitSchedulingType) {
        val toBeMapped = Either.ofRight<String, JitSchedulingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JitSchedulingPolicyArgs = JitSchedulingPolicyArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
