@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The application client details to track the entity creating/updating the managed app resource.
 * @property applicationId The client application Id.
 * @property oid The client Oid.
 * @property puid The client Puid
 */
public data class ApplicationClientDetailsResponse(
    public val applicationId: String? = null,
    public val oid: String? = null,
    public val puid: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationClientDetailsResponse):
            ApplicationClientDetailsResponse = ApplicationClientDetailsResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            oid = javaType.oid().map({ args0 -> args0 }).orElse(null),
            puid = javaType.puid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
