@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The appliance package support URLs.
 * @property governmentCloud The government cloud support URL.
 * @property publicAzure The public azure support URL.
 */
public data class ApplicationPackageSupportUrlsResponse(
    public val governmentCloud: String? = null,
    public val publicAzure: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationPackageSupportUrlsResponse):
            ApplicationPackageSupportUrlsResponse = ApplicationPackageSupportUrlsResponse(
            governmentCloud = javaType.governmentCloud().map({ args0 -> args0 }).orElse(null),
            publicAzure = javaType.publicAzure().map({ args0 -> args0 }).orElse(null),
        )
    }
}
