@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataMaskingPolicy].
 */
@PulumiTagMarker
public class DataMaskingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataMaskingPolicyArgs = DataMaskingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataMaskingPolicyArgsBuilder.() -> Unit) {
        val builder = DataMaskingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataMaskingPolicy {
        val builtJavaResource = com.pulumi.azurenative.sql.DataMaskingPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataMaskingPolicy(builtJavaResource)
    }
}

/**
 * A database data masking policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update data masking policy max
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataMaskingPolicy = new AzureNative.Sql.DataMaskingPolicy("dataMaskingPolicy", new()
 *     {
 *         DataMaskingPolicyName = "Default",
 *         DataMaskingState = AzureNative.Sql.DataMaskingState.Enabled,
 *         DatabaseName = "sqlcrudtest-331",
 *         ExemptPrincipals = "testuser;",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         ServerName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDataMaskingPolicy(ctx, "dataMaskingPolicy", &sql.DataMaskingPolicyArgs{
 * 			DataMaskingPolicyName: pulumi.String("Default"),
 * 			DataMaskingState:      sql.DataMaskingStateEnabled,
 * 			DatabaseName:          pulumi.String("sqlcrudtest-331"),
 * 			ExemptPrincipals:      pulumi.String("testuser;"),
 * 			ResourceGroupName:     pulumi.String("sqlcrudtest-6852"),
 * 			ServerName:            pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DataMaskingPolicy;
 * import com.pulumi.azurenative.sql.DataMaskingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataMaskingPolicy = new DataMaskingPolicy("dataMaskingPolicy", DataMaskingPolicyArgs.builder()
 *             .dataMaskingPolicyName("Default")
 *             .dataMaskingState("Enabled")
 *             .databaseName("sqlcrudtest-331")
 *             .exemptPrincipals("testuser;")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .serverName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update data masking policy min.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataMaskingPolicy = new AzureNative.Sql.DataMaskingPolicy("dataMaskingPolicy", new()
 *     {
 *         DataMaskingPolicyName = "Default",
 *         DataMaskingState = AzureNative.Sql.DataMaskingState.Enabled,
 *         DatabaseName = "sqlcrudtest-331",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         ServerName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDataMaskingPolicy(ctx, "dataMaskingPolicy", &sql.DataMaskingPolicyArgs{
 * 			DataMaskingPolicyName: pulumi.String("Default"),
 * 			DataMaskingState:      sql.DataMaskingStateEnabled,
 * 			DatabaseName:          pulumi.String("sqlcrudtest-331"),
 * 			ResourceGroupName:     pulumi.String("sqlcrudtest-6852"),
 * 			ServerName:            pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DataMaskingPolicy;
 * import com.pulumi.azurenative.sql.DataMaskingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataMaskingPolicy = new DataMaskingPolicy("dataMaskingPolicy", DataMaskingPolicyArgs.builder()
 *             .dataMaskingPolicyName("Default")
 *             .dataMaskingState("Enabled")
 *             .databaseName("sqlcrudtest-331")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .serverName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DataMaskingPolicy Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}
 * ```
 */
public class DataMaskingPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.DataMaskingPolicy,
) : KotlinCustomResource(javaResource, DataMaskingPolicyMapper) {
    /**
     * The list of the application principals. This is a legacy parameter and is no longer used.
     */
    public val applicationPrincipals: Output<String>
        get() = javaResource.applicationPrincipals().applyValue({ args0 -> args0 })

    /**
     * The state of the data masking policy.
     */
    public val dataMaskingState: Output<String>
        get() = javaResource.dataMaskingState().applyValue({ args0 -> args0 })

    /**
     * The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
     */
    public val exemptPrincipals: Output<String>?
        get() = javaResource.exemptPrincipals().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The kind of Data Masking Policy. Metadata, used for Azure portal.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The location of the data masking policy.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The masking level. This is a legacy parameter and is no longer used.
     */
    public val maskingLevel: Output<String>
        get() = javaResource.maskingLevel().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataMaskingPolicyMapper : ResourceMapper<DataMaskingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DataMaskingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DataMaskingPolicy = DataMaskingPolicy(
        javaResource as
            com.pulumi.azurenative.sql.DataMaskingPolicy,
    )
}

/**
 * @see [DataMaskingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataMaskingPolicy].
 */
public suspend fun dataMaskingPolicy(
    name: String,
    block: suspend DataMaskingPolicyResourceBuilder.() -> Unit,
): DataMaskingPolicy {
    val builder = DataMaskingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataMaskingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataMaskingPolicy(name: String): DataMaskingPolicy {
    val builder = DataMaskingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
