@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.BlobAuditingPolicyState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A database blob auditing policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a database's azure monitor auditing policy with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseBlobAuditingPolicy = new AzureNative.Sql.DatabaseBlobAuditingPolicy("databaseBlobAuditingPolicy", new()
 *     {
 *         BlobAuditingPolicyName = "default",
 *         DatabaseName = "testdb",
 *         IsAzureMonitorTargetEnabled = true,
 *         ResourceGroupName = "blobauditingtest-4799",
 *         ServerName = "blobauditingtest-6440",
 *         State = AzureNative.Sql.BlobAuditingPolicyState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseBlobAuditingPolicy(ctx, "databaseBlobAuditingPolicy", &sql.DatabaseBlobAuditingPolicyArgs{
 * 			BlobAuditingPolicyName:      pulumi.String("default"),
 * 			DatabaseName:                pulumi.String("testdb"),
 * 			IsAzureMonitorTargetEnabled: pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("blobauditingtest-4799"),
 * 			ServerName:                  pulumi.String("blobauditingtest-6440"),
 * 			State:                       sql.BlobAuditingPolicyStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicy;
 * import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseBlobAuditingPolicy = new DatabaseBlobAuditingPolicy("databaseBlobAuditingPolicy", DatabaseBlobAuditingPolicyArgs.builder()
 *             .blobAuditingPolicyName("default")
 *             .databaseName("testdb")
 *             .isAzureMonitorTargetEnabled(true)
 *             .resourceGroupName("blobauditingtest-4799")
 *             .serverName("blobauditingtest-6440")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a database's blob auditing policy with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseBlobAuditingPolicy = new AzureNative.Sql.DatabaseBlobAuditingPolicy("databaseBlobAuditingPolicy", new()
 *     {
 *         AuditActionsAndGroups = new[]
 *         {
 *             "DATABASE_LOGOUT_GROUP",
 *             "DATABASE_ROLE_MEMBER_CHANGE_GROUP",
 *             "UPDATE on database::TestDatabaseName by public",
 *         },
 *         BlobAuditingPolicyName = "default",
 *         DatabaseName = "testdb",
 *         IsAzureMonitorTargetEnabled = true,
 *         IsStorageSecondaryKeyInUse = false,
 *         QueueDelayMs = 4000,
 *         ResourceGroupName = "blobauditingtest-4799",
 *         RetentionDays = 6,
 *         ServerName = "blobauditingtest-6440",
 *         State = AzureNative.Sql.BlobAuditingPolicyState.Enabled,
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageAccountSubscriptionId = "00000000-1234-0000-5678-000000000000",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseBlobAuditingPolicy(ctx, "databaseBlobAuditingPolicy", &sql.DatabaseBlobAuditingPolicyArgs{
 * 			AuditActionsAndGroups: pulumi.StringArray{
 * 				pulumi.String("DATABASE_LOGOUT_GROUP"),
 * 				pulumi.String("DATABASE_ROLE_MEMBER_CHANGE_GROUP"),
 * 				pulumi.String("UPDATE on database::TestDatabaseName by public"),
 * 			},
 * 			BlobAuditingPolicyName:       pulumi.String("default"),
 * 			DatabaseName:                 pulumi.String("testdb"),
 * 			IsAzureMonitorTargetEnabled:  pulumi.Bool(true),
 * 			IsStorageSecondaryKeyInUse:   pulumi.Bool(false),
 * 			QueueDelayMs:                 pulumi.Int(4000),
 * 			ResourceGroupName:            pulumi.String("blobauditingtest-4799"),
 * 			RetentionDays:                pulumi.Int(6),
 * 			ServerName:                   pulumi.String("blobauditingtest-6440"),
 * 			State:                        sql.BlobAuditingPolicyStateEnabled,
 * 			StorageAccountAccessKey:      pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageAccountSubscriptionId: pulumi.String("00000000-1234-0000-5678-000000000000"),
 * 			StorageEndpoint:              pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicy;
 * import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseBlobAuditingPolicy = new DatabaseBlobAuditingPolicy("databaseBlobAuditingPolicy", DatabaseBlobAuditingPolicyArgs.builder()
 *             .auditActionsAndGroups(
 *                 "DATABASE_LOGOUT_GROUP",
 *                 "DATABASE_ROLE_MEMBER_CHANGE_GROUP",
 *                 "UPDATE on database::TestDatabaseName by public")
 *             .blobAuditingPolicyName("default")
 *             .databaseName("testdb")
 *             .isAzureMonitorTargetEnabled(true)
 *             .isStorageSecondaryKeyInUse(false)
 *             .queueDelayMs(4000)
 *             .resourceGroupName("blobauditingtest-4799")
 *             .retentionDays(6)
 *             .serverName("blobauditingtest-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageAccountSubscriptionId("00000000-1234-0000-5678-000000000000")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a database's blob auditing policy with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseBlobAuditingPolicy = new AzureNative.Sql.DatabaseBlobAuditingPolicy("databaseBlobAuditingPolicy", new()
 *     {
 *         BlobAuditingPolicyName = "default",
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "blobauditingtest-4799",
 *         ServerName = "blobauditingtest-6440",
 *         State = AzureNative.Sql.BlobAuditingPolicyState.Enabled,
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseBlobAuditingPolicy(ctx, "databaseBlobAuditingPolicy", &sql.DatabaseBlobAuditingPolicyArgs{
 * 			BlobAuditingPolicyName:  pulumi.String("default"),
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			ResourceGroupName:       pulumi.String("blobauditingtest-4799"),
 * 			ServerName:              pulumi.String("blobauditingtest-6440"),
 * 			State:                   sql.BlobAuditingPolicyStateEnabled,
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicy;
 * import com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseBlobAuditingPolicy = new DatabaseBlobAuditingPolicy("databaseBlobAuditingPolicy", DatabaseBlobAuditingPolicyArgs.builder()
 *             .blobAuditingPolicyName("default")
 *             .databaseName("testdb")
 *             .resourceGroupName("blobauditingtest-4799")
 *             .serverName("blobauditingtest-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseBlobAuditingPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingSettings/{blobAuditingPolicyName}
 * ```
 * @property auditActionsAndGroups Specifies the Actions-Groups and Actions to audit.
 * The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
 * BATCH_COMPLETED_GROUP,
 * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
 * FAILED_DATABASE_AUTHENTICATION_GROUP.
 * This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
 * The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
 * APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
 * BACKUP_RESTORE_GROUP
 * DATABASE_LOGOUT_GROUP
 * DATABASE_OBJECT_CHANGE_GROUP
 * DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
 * DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
 * DATABASE_OPERATION_GROUP
 * DATABASE_PERMISSION_CHANGE_GROUP
 * DATABASE_PRINCIPAL_CHANGE_GROUP
 * DATABASE_PRINCIPAL_IMPERSONATION_GROUP
 * DATABASE_ROLE_MEMBER_CHANGE_GROUP
 * FAILED_DATABASE_AUTHENTICATION_GROUP
 * SCHEMA_OBJECT_ACCESS_GROUP
 * SCHEMA_OBJECT_CHANGE_GROUP
 * SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
 * SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
 * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
 * USER_CHANGE_PASSWORD_GROUP
 * BATCH_STARTED_GROUP
 * BATCH_COMPLETED_GROUP
 * DBCC_GROUP
 * DATABASE_OWNERSHIP_CHANGE_GROUP
 * DATABASE_CHANGE_GROUP
 * LEDGER_OPERATION_GROUP
 * These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
 * For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
 * For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
 * SELECT
 * UPDATE
 * INSERT
 * DELETE
 * EXECUTE
 * RECEIVE
 * REFERENCES
 * The general form for defining an action to be audited is:
 * {action} ON {object} BY {principal}
 * Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
 * For example:
 * SELECT on dbo.myTable by public
 * SELECT on DATABASE::myDatabase by public
 * SELECT on SCHEMA::mySchema by public
 * For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
 * @property blobAuditingPolicyName The name of the blob auditing policy.
 * @property databaseName The name of the database.
 * @property isAzureMonitorTargetEnabled Specifies whether audit events are sent to Azure Monitor.
 * In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
 * When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
 * Note that for server level audit you should use the 'master' database as {databaseName}.
 * Diagnostic Settings URI format:
 * PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
 * For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
 * or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
 * @property isManagedIdentityInUse Specifies whether Managed Identity is used to access blob storage
 * @property isStorageSecondaryKeyInUse Specifies whether storageAccountAccessKey value is the storage's secondary key.
 * @property queueDelayMs Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
 * The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property retentionDays Specifies the number of days to keep in the audit logs in the storage account.
 * @property serverName The name of the server.
 * @property state Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
 * @property storageAccountAccessKey Specifies the identifier key of the auditing storage account.
 * If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
 * Prerequisites for using managed identity authentication:
 * 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
 * 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
 * For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
 * @property storageAccountSubscriptionId Specifies the blob storage subscription Id.
 * @property storageEndpoint Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
 */
public data class DatabaseBlobAuditingPolicyArgs(
    public val auditActionsAndGroups: Output<List<String>>? = null,
    public val blobAuditingPolicyName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val isAzureMonitorTargetEnabled: Output<Boolean>? = null,
    public val isManagedIdentityInUse: Output<Boolean>? = null,
    public val isStorageSecondaryKeyInUse: Output<Boolean>? = null,
    public val queueDelayMs: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val serverName: Output<String>? = null,
    public val state: Output<BlobAuditingPolicyState>? = null,
    public val storageAccountAccessKey: Output<String>? = null,
    public val storageAccountSubscriptionId: Output<String>? = null,
    public val storageEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs =
        com.pulumi.azurenative.sql.DatabaseBlobAuditingPolicyArgs.builder()
            .auditActionsAndGroups(auditActionsAndGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .blobAuditingPolicyName(blobAuditingPolicyName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .isAzureMonitorTargetEnabled(isAzureMonitorTargetEnabled?.applyValue({ args0 -> args0 }))
            .isManagedIdentityInUse(isManagedIdentityInUse?.applyValue({ args0 -> args0 }))
            .isStorageSecondaryKeyInUse(isStorageSecondaryKeyInUse?.applyValue({ args0 -> args0 }))
            .queueDelayMs(queueDelayMs?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountAccessKey(storageAccountAccessKey?.applyValue({ args0 -> args0 }))
            .storageAccountSubscriptionId(storageAccountSubscriptionId?.applyValue({ args0 -> args0 }))
            .storageEndpoint(storageEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseBlobAuditingPolicyArgs].
 */
@PulumiTagMarker
public class DatabaseBlobAuditingPolicyArgsBuilder internal constructor() {
    private var auditActionsAndGroups: Output<List<String>>? = null

    private var blobAuditingPolicyName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var isAzureMonitorTargetEnabled: Output<Boolean>? = null

    private var isManagedIdentityInUse: Output<Boolean>? = null

    private var isStorageSecondaryKeyInUse: Output<Boolean>? = null

    private var queueDelayMs: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var serverName: Output<String>? = null

    private var state: Output<BlobAuditingPolicyState>? = null

    private var storageAccountAccessKey: Output<String>? = null

    private var storageAccountSubscriptionId: Output<String>? = null

    private var storageEndpoint: Output<String>? = null

    /**
     * @param value Specifies the Actions-Groups and Actions to audit.
     * The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
     * BATCH_COMPLETED_GROUP,
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     * FAILED_DATABASE_AUTHENTICATION_GROUP.
     * This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
     * The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
     * APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     * BACKUP_RESTORE_GROUP
     * DATABASE_LOGOUT_GROUP
     * DATABASE_OBJECT_CHANGE_GROUP
     * DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     * DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     * DATABASE_OPERATION_GROUP
     * DATABASE_PERMISSION_CHANGE_GROUP
     * DATABASE_PRINCIPAL_CHANGE_GROUP
     * DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     * DATABASE_ROLE_MEMBER_CHANGE_GROUP
     * FAILED_DATABASE_AUTHENTICATION_GROUP
     * SCHEMA_OBJECT_ACCESS_GROUP
     * SCHEMA_OBJECT_CHANGE_GROUP
     * SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     * SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     * USER_CHANGE_PASSWORD_GROUP
     * BATCH_STARTED_GROUP
     * BATCH_COMPLETED_GROUP
     * DBCC_GROUP
     * DATABASE_OWNERSHIP_CHANGE_GROUP
     * DATABASE_CHANGE_GROUP
     * LEDGER_OPERATION_GROUP
     * These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
     * For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     * For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
     * SELECT
     * UPDATE
     * INSERT
     * DELETE
     * EXECUTE
     * RECEIVE
     * REFERENCES
     * The general form for defining an action to be audited is:
     * {action} ON {object} BY {principal}
     * Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
     * For example:
     * SELECT on dbo.myTable by public
     * SELECT on DATABASE::myDatabase by public
     * SELECT on SCHEMA::mySchema by public
     * For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
     */
    @JvmName("ohvpftmokgwgkujr")
    public suspend fun auditActionsAndGroups(`value`: Output<List<String>>) {
        this.auditActionsAndGroups = value
    }

    @JvmName("eyquahpihwibdanj")
    public suspend fun auditActionsAndGroups(vararg values: Output<String>) {
        this.auditActionsAndGroups = Output.all(values.asList())
    }

    /**
     * @param values Specifies the Actions-Groups and Actions to audit.
     * The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
     * BATCH_COMPLETED_GROUP,
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     * FAILED_DATABASE_AUTHENTICATION_GROUP.
     * This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
     * The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
     * APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     * BACKUP_RESTORE_GROUP
     * DATABASE_LOGOUT_GROUP
     * DATABASE_OBJECT_CHANGE_GROUP
     * DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     * DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     * DATABASE_OPERATION_GROUP
     * DATABASE_PERMISSION_CHANGE_GROUP
     * DATABASE_PRINCIPAL_CHANGE_GROUP
     * DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     * DATABASE_ROLE_MEMBER_CHANGE_GROUP
     * FAILED_DATABASE_AUTHENTICATION_GROUP
     * SCHEMA_OBJECT_ACCESS_GROUP
     * SCHEMA_OBJECT_CHANGE_GROUP
     * SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     * SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     * USER_CHANGE_PASSWORD_GROUP
     * BATCH_STARTED_GROUP
     * BATCH_COMPLETED_GROUP
     * DBCC_GROUP
     * DATABASE_OWNERSHIP_CHANGE_GROUP
     * DATABASE_CHANGE_GROUP
     * LEDGER_OPERATION_GROUP
     * These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
     * For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     * For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
     * SELECT
     * UPDATE
     * INSERT
     * DELETE
     * EXECUTE
     * RECEIVE
     * REFERENCES
     * The general form for defining an action to be audited is:
     * {action} ON {object} BY {principal}
     * Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
     * For example:
     * SELECT on dbo.myTable by public
     * SELECT on DATABASE::myDatabase by public
     * SELECT on SCHEMA::mySchema by public
     * For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
     */
    @JvmName("mybwiianutqpdiih")
    public suspend fun auditActionsAndGroups(values: List<Output<String>>) {
        this.auditActionsAndGroups = Output.all(values)
    }

    /**
     * @param value The name of the blob auditing policy.
     */
    @JvmName("fxtsoxmsmtqfucph")
    public suspend fun blobAuditingPolicyName(`value`: Output<String>) {
        this.blobAuditingPolicyName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("liblvvbrhmveugir")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Specifies whether audit events are sent to Azure Monitor.
     * In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
     * When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
     * Note that for server level audit you should use the 'master' database as {databaseName}.
     * Diagnostic Settings URI format:
     * PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     * For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
     * or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
     */
    @JvmName("yojeqhjljmhjicgj")
    public suspend fun isAzureMonitorTargetEnabled(`value`: Output<Boolean>) {
        this.isAzureMonitorTargetEnabled = value
    }

    /**
     * @param value Specifies whether Managed Identity is used to access blob storage
     */
    @JvmName("wcqqvrenklajqegh")
    public suspend fun isManagedIdentityInUse(`value`: Output<Boolean>) {
        this.isManagedIdentityInUse = value
    }

    /**
     * @param value Specifies whether storageAccountAccessKey value is the storage's secondary key.
     */
    @JvmName("kmnxeiktkdbitwno")
    public suspend fun isStorageSecondaryKeyInUse(`value`: Output<Boolean>) {
        this.isStorageSecondaryKeyInUse = value
    }

    /**
     * @param value Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
     * The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
     */
    @JvmName("ynnvglnkmtvlyqts")
    public suspend fun queueDelayMs(`value`: Output<Int>) {
        this.queueDelayMs = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kdpoiuvjxfamngul")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the number of days to keep in the audit logs in the storage account.
     */
    @JvmName("voysskggaqcwjixi")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("oaytobjwwwnsvlkf")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     */
    @JvmName("fuvehlswhbjokgky")
    public suspend fun state(`value`: Output<BlobAuditingPolicyState>) {
        this.state = value
    }

    /**
     * @param value Specifies the identifier key of the auditing storage account.
     * If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
     * Prerequisites for using managed identity authentication:
     * 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     * 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
     * For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
     */
    @JvmName("qolmelxlewjutoxg")
    public suspend fun storageAccountAccessKey(`value`: Output<String>) {
        this.storageAccountAccessKey = value
    }

    /**
     * @param value Specifies the blob storage subscription Id.
     */
    @JvmName("ohvguwiwthtkamqh")
    public suspend fun storageAccountSubscriptionId(`value`: Output<String>) {
        this.storageAccountSubscriptionId = value
    }

    /**
     * @param value Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
     */
    @JvmName("grdhukdeknioralg")
    public suspend fun storageEndpoint(`value`: Output<String>) {
        this.storageEndpoint = value
    }

    /**
     * @param value Specifies the Actions-Groups and Actions to audit.
     * The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
     * BATCH_COMPLETED_GROUP,
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     * FAILED_DATABASE_AUTHENTICATION_GROUP.
     * This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
     * The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
     * APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     * BACKUP_RESTORE_GROUP
     * DATABASE_LOGOUT_GROUP
     * DATABASE_OBJECT_CHANGE_GROUP
     * DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     * DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     * DATABASE_OPERATION_GROUP
     * DATABASE_PERMISSION_CHANGE_GROUP
     * DATABASE_PRINCIPAL_CHANGE_GROUP
     * DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     * DATABASE_ROLE_MEMBER_CHANGE_GROUP
     * FAILED_DATABASE_AUTHENTICATION_GROUP
     * SCHEMA_OBJECT_ACCESS_GROUP
     * SCHEMA_OBJECT_CHANGE_GROUP
     * SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     * SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     * USER_CHANGE_PASSWORD_GROUP
     * BATCH_STARTED_GROUP
     * BATCH_COMPLETED_GROUP
     * DBCC_GROUP
     * DATABASE_OWNERSHIP_CHANGE_GROUP
     * DATABASE_CHANGE_GROUP
     * LEDGER_OPERATION_GROUP
     * These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
     * For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     * For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
     * SELECT
     * UPDATE
     * INSERT
     * DELETE
     * EXECUTE
     * RECEIVE
     * REFERENCES
     * The general form for defining an action to be audited is:
     * {action} ON {object} BY {principal}
     * Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
     * For example:
     * SELECT on dbo.myTable by public
     * SELECT on DATABASE::myDatabase by public
     * SELECT on SCHEMA::mySchema by public
     * For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
     */
    @JvmName("hnqoyseptllbgwxi")
    public suspend fun auditActionsAndGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditActionsAndGroups = mapped
    }

    /**
     * @param values Specifies the Actions-Groups and Actions to audit.
     * The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
     * BATCH_COMPLETED_GROUP,
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     * FAILED_DATABASE_AUTHENTICATION_GROUP.
     * This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
     * The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
     * APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     * BACKUP_RESTORE_GROUP
     * DATABASE_LOGOUT_GROUP
     * DATABASE_OBJECT_CHANGE_GROUP
     * DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     * DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     * DATABASE_OPERATION_GROUP
     * DATABASE_PERMISSION_CHANGE_GROUP
     * DATABASE_PRINCIPAL_CHANGE_GROUP
     * DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     * DATABASE_ROLE_MEMBER_CHANGE_GROUP
     * FAILED_DATABASE_AUTHENTICATION_GROUP
     * SCHEMA_OBJECT_ACCESS_GROUP
     * SCHEMA_OBJECT_CHANGE_GROUP
     * SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     * SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     * USER_CHANGE_PASSWORD_GROUP
     * BATCH_STARTED_GROUP
     * BATCH_COMPLETED_GROUP
     * DBCC_GROUP
     * DATABASE_OWNERSHIP_CHANGE_GROUP
     * DATABASE_CHANGE_GROUP
     * LEDGER_OPERATION_GROUP
     * These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
     * For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     * For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
     * SELECT
     * UPDATE
     * INSERT
     * DELETE
     * EXECUTE
     * RECEIVE
     * REFERENCES
     * The general form for defining an action to be audited is:
     * {action} ON {object} BY {principal}
     * Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
     * For example:
     * SELECT on dbo.myTable by public
     * SELECT on DATABASE::myDatabase by public
     * SELECT on SCHEMA::mySchema by public
     * For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
     */
    @JvmName("qsgbqwyrujcwrdwu")
    public suspend fun auditActionsAndGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auditActionsAndGroups = mapped
    }

    /**
     * @param value The name of the blob auditing policy.
     */
    @JvmName("dmksrwtaxvwyvnjb")
    public suspend fun blobAuditingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobAuditingPolicyName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("icnqpqylkgwhmnja")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Specifies whether audit events are sent to Azure Monitor.
     * In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
     * When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
     * Note that for server level audit you should use the 'master' database as {databaseName}.
     * Diagnostic Settings URI format:
     * PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     * For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
     * or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
     */
    @JvmName("jkjbcnkwpribrtfv")
    public suspend fun isAzureMonitorTargetEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAzureMonitorTargetEnabled = mapped
    }

    /**
     * @param value Specifies whether Managed Identity is used to access blob storage
     */
    @JvmName("ecymgkppsxxrurew")
    public suspend fun isManagedIdentityInUse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isManagedIdentityInUse = mapped
    }

    /**
     * @param value Specifies whether storageAccountAccessKey value is the storage's secondary key.
     */
    @JvmName("cfymrmfxeicfrsew")
    public suspend fun isStorageSecondaryKeyInUse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isStorageSecondaryKeyInUse = mapped
    }

    /**
     * @param value Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
     * The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
     */
    @JvmName("emqfhkaqaaafqetq")
    public suspend fun queueDelayMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueDelayMs = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gtyxxkichavtaqyd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the number of days to keep in the audit logs in the storage account.
     */
    @JvmName("qxtyfgjjcrxhijkj")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("hfsalxknpvtahunh")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     */
    @JvmName("mamldifisvglbnoj")
    public suspend fun state(`value`: BlobAuditingPolicyState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Specifies the identifier key of the auditing storage account.
     * If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
     * Prerequisites for using managed identity authentication:
     * 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     * 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
     * For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
     */
    @JvmName("ahwueuqwbjdfianw")
    public suspend fun storageAccountAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessKey = mapped
    }

    /**
     * @param value Specifies the blob storage subscription Id.
     */
    @JvmName("sklexvhdkprgrnlq")
    public suspend fun storageAccountSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSubscriptionId = mapped
    }

    /**
     * @param value Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
     */
    @JvmName("gogfjcsedemtxofa")
    public suspend fun storageEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEndpoint = mapped
    }

    internal fun build(): DatabaseBlobAuditingPolicyArgs = DatabaseBlobAuditingPolicyArgs(
        auditActionsAndGroups = auditActionsAndGroups,
        blobAuditingPolicyName = blobAuditingPolicyName,
        databaseName = databaseName,
        isAzureMonitorTargetEnabled = isAzureMonitorTargetEnabled,
        isManagedIdentityInUse = isManagedIdentityInUse,
        isStorageSecondaryKeyInUse = isStorageSecondaryKeyInUse,
        queueDelayMs = queueDelayMs,
        resourceGroupName = resourceGroupName,
        retentionDays = retentionDays,
        serverName = serverName,
        state = state,
        storageAccountAccessKey = storageAccountAccessKey,
        storageAccountSubscriptionId = storageAccountSubscriptionId,
        storageEndpoint = storageEndpoint,
    )
}
