@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.SecurityAlertPolicyEmailAccountAdmins
import com.pulumi.azurenative.sql.kotlin.enums.SecurityAlertPolicyState
import com.pulumi.azurenative.sql.kotlin.enums.SecurityAlertPolicyUseServerDefault
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about a database Threat Detection policy.
 * Azure REST API version: 2014-04-01.
 * ## Example Usage
 * ### Create database security alert policy max
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseThreatDetectionPolicy = new AzureNative.Sql.DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         DisabledAlerts = "Sql_Injection;Usage_Anomaly;",
 *         EmailAccountAdmins = "Enabled",
 *         EmailAddresses = "test@microsoft.com;user@microsoft.com",
 *         ResourceGroupName = "securityalert-4799",
 *         RetentionDays = 6,
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = "Enabled",
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *         UseServerDefault = "Enabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseThreatDetectionPolicy(ctx, "databaseThreatDetectionPolicy", &sql.DatabaseThreatDetectionPolicyArgs{
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			DisabledAlerts:          pulumi.String("Sql_Injection;Usage_Anomaly;"),
 * 			EmailAccountAdmins:      pulumi.String("Enabled"),
 * 			EmailAddresses:          pulumi.String("test@microsoft.com;user@microsoft.com"),
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			RetentionDays:           pulumi.Int(6),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   pulumi.String("Enabled"),
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 			UseServerDefault:        pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseThreatDetectionPolicy = new DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", DatabaseThreatDetectionPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .disabledAlerts("Sql_Injection;Usage_Anomaly;")
 *             .emailAccountAdmins("Enabled")
 *             .emailAddresses("test@microsoft.com;user@microsoft.com")
 *             .resourceGroupName("securityalert-4799")
 *             .retentionDays(6)
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .useServerDefault("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Create database security alert policy min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseThreatDetectionPolicy = new AzureNative.Sql.DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "securityalert-4799",
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = "Enabled",
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseThreatDetectionPolicy(ctx, "databaseThreatDetectionPolicy", &sql.DatabaseThreatDetectionPolicyArgs{
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   pulumi.String("Enabled"),
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseThreatDetectionPolicy = new DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", DatabaseThreatDetectionPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .resourceGroupName("securityalert-4799")
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseThreatDetectionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}
 * ```
 * @property databaseName The name of the database for which database Threat Detection policy is defined.
 * @property disabledAlerts Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
 * @property emailAccountAdmins Specifies that the alert is sent to the account administrators.
 * @property emailAddresses Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property retentionDays Specifies the number of days to keep in the Threat Detection audit logs.
 * @property securityAlertPolicyName The name of the security alert policy.
 * @property serverName The name of the server.
 * @property state Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
 * @property storageAccountAccessKey Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
 * @property storageEndpoint Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
 * @property useServerDefault Specifies whether to use the default server policy.
 */
public data class DatabaseThreatDetectionPolicyArgs(
    public val databaseName: Output<String>? = null,
    public val disabledAlerts: Output<String>? = null,
    public val emailAccountAdmins: Output<Either<String, SecurityAlertPolicyEmailAccountAdmins>>? =
        null,
    public val emailAddresses: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val securityAlertPolicyName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val state: Output<Either<String, SecurityAlertPolicyState>>? = null,
    public val storageAccountAccessKey: Output<String>? = null,
    public val storageEndpoint: Output<String>? = null,
    public val useServerDefault: Output<Either<String, SecurityAlertPolicyUseServerDefault>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs =
        com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .disabledAlerts(disabledAlerts?.applyValue({ args0 -> args0 }))
            .emailAccountAdmins(
                emailAccountAdmins?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .emailAddresses(emailAddresses?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .securityAlertPolicyName(securityAlertPolicyName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageAccountAccessKey(storageAccountAccessKey?.applyValue({ args0 -> args0 }))
            .storageEndpoint(storageEndpoint?.applyValue({ args0 -> args0 }))
            .useServerDefault(
                useServerDefault?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DatabaseThreatDetectionPolicyArgs].
 */
@PulumiTagMarker
public class DatabaseThreatDetectionPolicyArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var disabledAlerts: Output<String>? = null

    private var emailAccountAdmins: Output<Either<String, SecurityAlertPolicyEmailAccountAdmins>>? =
        null

    private var emailAddresses: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var securityAlertPolicyName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var state: Output<Either<String, SecurityAlertPolicyState>>? = null

    private var storageAccountAccessKey: Output<String>? = null

    private var storageEndpoint: Output<String>? = null

    private var useServerDefault: Output<Either<String, SecurityAlertPolicyUseServerDefault>>? = null

    /**
     * @param value The name of the database for which database Threat Detection policy is defined.
     */
    @JvmName("erkelrxbjosywhxm")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
     */
    @JvmName("fwqbcbahftlkcsuy")
    public suspend fun disabledAlerts(`value`: Output<String>) {
        this.disabledAlerts = value
    }

    /**
     * @param value Specifies that the alert is sent to the account administrators.
     */
    @JvmName("vwhgvfsionaaqhhr")
    public suspend
    fun emailAccountAdmins(`value`: Output<Either<String, SecurityAlertPolicyEmailAccountAdmins>>) {
        this.emailAccountAdmins = value
    }

    /**
     * @param value Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
     */
    @JvmName("sjwvkcwfmgrajsvg")
    public suspend fun emailAddresses(`value`: Output<String>) {
        this.emailAddresses = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("oaptpkkgbkkhkqsv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("oxiobfylwqwvgxxe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the number of days to keep in the Threat Detection audit logs.
     */
    @JvmName("tpmxgrqtkuayjplj")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The name of the security alert policy.
     */
    @JvmName("jajalvxuahrpibwg")
    public suspend fun securityAlertPolicyName(`value`: Output<String>) {
        this.securityAlertPolicyName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("comapvppeuiydbvg")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
     */
    @JvmName("akqqgpadqhifprvq")
    public suspend fun state(`value`: Output<Either<String, SecurityAlertPolicyState>>) {
        this.state = value
    }

    /**
     * @param value Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
     */
    @JvmName("meuwihrscspupwak")
    public suspend fun storageAccountAccessKey(`value`: Output<String>) {
        this.storageAccountAccessKey = value
    }

    /**
     * @param value Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
     */
    @JvmName("unwekybukbluoned")
    public suspend fun storageEndpoint(`value`: Output<String>) {
        this.storageEndpoint = value
    }

    /**
     * @param value Specifies whether to use the default server policy.
     */
    @JvmName("pbqgxylxowkoowku")
    public suspend
    fun useServerDefault(`value`: Output<Either<String, SecurityAlertPolicyUseServerDefault>>) {
        this.useServerDefault = value
    }

    /**
     * @param value The name of the database for which database Threat Detection policy is defined.
     */
    @JvmName("ajyacdtxrqwacdap")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
     */
    @JvmName("wemadvdkcdobsosb")
    public suspend fun disabledAlerts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledAlerts = mapped
    }

    /**
     * @param value Specifies that the alert is sent to the account administrators.
     */
    @JvmName("iyxdydyhfyjvhaxj")
    public suspend
    fun emailAccountAdmins(`value`: Either<String, SecurityAlertPolicyEmailAccountAdmins>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAccountAdmins = mapped
    }

    /**
     * @param value Specifies that the alert is sent to the account administrators.
     */
    @JvmName("ulsdhmemvymuscsg")
    public fun emailAccountAdmins(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityAlertPolicyEmailAccountAdmins>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAccountAdmins = mapped
    }

    /**
     * @param value Specifies that the alert is sent to the account administrators.
     */
    @JvmName("hyokoauolxcrdapt")
    public fun emailAccountAdmins(`value`: SecurityAlertPolicyEmailAccountAdmins) {
        val toBeMapped = Either.ofRight<String, SecurityAlertPolicyEmailAccountAdmins>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAccountAdmins = mapped
    }

    /**
     * @param value Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
     */
    @JvmName("hyysjfnbiwtldoqv")
    public suspend fun emailAddresses(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rqvmkaswfjstrboa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mnxeqahkvvlmewaw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the number of days to keep in the Threat Detection audit logs.
     */
    @JvmName("qijuaaubuomikuij")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The name of the security alert policy.
     */
    @JvmName("nykmegbcdgxmfeya")
    public suspend fun securityAlertPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityAlertPolicyName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("cvqjrqmlifxhsujx")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
     */
    @JvmName("ybumfrnggcnjoona")
    public suspend fun state(`value`: Either<String, SecurityAlertPolicyState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
     */
    @JvmName("lixnyrvcsctqtmhy")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityAlertPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
     */
    @JvmName("semqkjjfxocerrmq")
    public fun state(`value`: SecurityAlertPolicyState) {
        val toBeMapped = Either.ofRight<String, SecurityAlertPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
     */
    @JvmName("sgchrhsjdkvqevvj")
    public suspend fun storageAccountAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessKey = mapped
    }

    /**
     * @param value Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
     */
    @JvmName("sswrysqmpgpqcogi")
    public suspend fun storageEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEndpoint = mapped
    }

    /**
     * @param value Specifies whether to use the default server policy.
     */
    @JvmName("ygeygglilynuirlm")
    public suspend
    fun useServerDefault(`value`: Either<String, SecurityAlertPolicyUseServerDefault>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useServerDefault = mapped
    }

    /**
     * @param value Specifies whether to use the default server policy.
     */
    @JvmName("rprmpuatbwpfnlma")
    public fun useServerDefault(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityAlertPolicyUseServerDefault>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useServerDefault = mapped
    }

    /**
     * @param value Specifies whether to use the default server policy.
     */
    @JvmName("xopkmgmvgijuuqmo")
    public fun useServerDefault(`value`: SecurityAlertPolicyUseServerDefault) {
        val toBeMapped = Either.ofRight<String, SecurityAlertPolicyUseServerDefault>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useServerDefault = mapped
    }

    internal fun build(): DatabaseThreatDetectionPolicyArgs = DatabaseThreatDetectionPolicyArgs(
        databaseName = databaseName,
        disabledAlerts = disabledAlerts,
        emailAccountAdmins = emailAccountAdmins,
        emailAddresses = emailAddresses,
        location = location,
        resourceGroupName = resourceGroupName,
        retentionDays = retentionDays,
        securityAlertPolicyName = securityAlertPolicyName,
        serverName = serverName,
        state = state,
        storageAccountAccessKey = storageAccountAccessKey,
        storageEndpoint = storageEndpoint,
        useServerDefault = useServerDefault,
    )
}
