@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.ElasticPoolPerDatabaseSettingsResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.sql.kotlin.outputs.ElasticPoolPerDatabaseSettingsResponse.Companion.toKotlin as elasticPoolPerDatabaseSettingsResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [ElasticPool].
 */
@PulumiTagMarker
public class ElasticPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ElasticPoolArgs = ElasticPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ElasticPoolArgsBuilder.() -> Unit) {
        val builder = ElasticPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ElasticPool {
        val builtJavaResource = com.pulumi.azurenative.sql.ElasticPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ElasticPool(builtJavaResource)
    }
}

/**
 * An elastic pool.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update Hyperscale elastic pool with high availability replica count parameter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         HighAvailabilityReplicaCount = 2,
 *         Location = "Japan East",
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "HS_Gen5_4",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName:              pulumi.String("sqlcrudtest-8102"),
 * 			HighAvailabilityReplicaCount: pulumi.Int(2),
 * 			Location:                     pulumi.String("Japan East"),
 * 			ResourceGroupName:            pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:                   pulumi.String("sqlcrudtest-8069"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("HS_Gen5_4"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .highAvailabilityReplicaCount(2)
 *             .location("Japan East")
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .sku(Map.of("name", "HS_Gen5_4"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update elastic pool with all parameter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         Location = "Japan East",
 *         PerDatabaseSettings = new AzureNative.Sql.Inputs.ElasticPoolPerDatabaseSettingsArgs
 *         {
 *             MaxCapacity = 2,
 *             MinCapacity = 0.25,
 *         },
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "GP_Gen4_2",
 *             Tier = "GeneralPurpose",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName: pulumi.String("sqlcrudtest-8102"),
 * 			Location:        pulumi.String("Japan East"),
 * 			PerDatabaseSettings: &sql.ElasticPoolPerDatabaseSettingsArgs{
 * 				MaxCapacity: pulumi.Float64(2),
 * 				MinCapacity: pulumi.Float64(0.25),
 * 			},
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:        pulumi.String("sqlcrudtest-8069"),
 * 			Sku: &sql.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("GP_Gen4_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .location("Japan East")
 *             .perDatabaseSettings(Map.ofEntries(
 *                 Map.entry("maxCapacity", 2),
 *                 Map.entry("minCapacity", 0.25)
 *             ))
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "GP_Gen4_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update elastic pool with maintenance configuration parameter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         Location = "Japan East",
 *         MaintenanceConfigurationId = "/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_1",
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName:            pulumi.String("sqlcrudtest-8102"),
 * 			Location:                   pulumi.String("Japan East"),
 * 			MaintenanceConfigurationId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_1"),
 * 			ResourceGroupName:          pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:                 pulumi.String("sqlcrudtest-8069"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .location("Japan East")
 *             .maintenanceConfigurationId("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_1")
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update elastic pool with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticPool = new AzureNative.Sql.ElasticPool("elasticPool", new()
 *     {
 *         ElasticPoolName = "sqlcrudtest-8102",
 *         Location = "Japan East",
 *         ResourceGroupName = "sqlcrudtest-2369",
 *         ServerName = "sqlcrudtest-8069",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewElasticPool(ctx, "elasticPool", &sql.ElasticPoolArgs{
 * 			ElasticPoolName:   pulumi.String("sqlcrudtest-8102"),
 * 			Location:          pulumi.String("Japan East"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-2369"),
 * 			ServerName:        pulumi.String("sqlcrudtest-8069"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ElasticPool;
 * import com.pulumi.azurenative.sql.ElasticPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticPool = new ElasticPool("elasticPool", ElasticPoolArgs.builder()
 *             .elasticPoolName("sqlcrudtest-8102")
 *             .location("Japan East")
 *             .resourceGroupName("sqlcrudtest-2369")
 *             .serverName("sqlcrudtest-8069")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ElasticPool sqlcrudtest-8102 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}
 * ```
 */
public class ElasticPool internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ElasticPool,
) : KotlinCustomResource(javaResource, ElasticPoolMapper) {
    /**
     * The creation date of the elastic pool (ISO8601 format).
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools.
     */
    public val highAvailabilityReplicaCount: Output<Int>?
        get() = javaResource.highAvailabilityReplicaCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of elastic pool. This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The license type to apply for this elastic pool.
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
     */
    public val maintenanceConfigurationId: Output<String>?
        get() = javaResource.maintenanceConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage limit for the database elastic pool in bytes.
     */
    public val maxSizeBytes: Output<Double>?
        get() = javaResource.maxSizeBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimal capacity that serverless pool will not shrink below, if not paused
     */
    public val minCapacity: Output<Double>?
        get() = javaResource.minCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The per database settings for the elastic pool.
     */
    public val perDatabaseSettings: Output<ElasticPoolPerDatabaseSettingsResponse>?
        get() = javaResource.perDatabaseSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> elasticPoolPerDatabaseSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The elastic pool SKU.
     * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
     * ```azurecli
     * az sql elastic-pool list-editions -l <location> -o table
     * ````
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The state of the elastic pool.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ElasticPoolMapper : ResourceMapper<ElasticPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ElasticPool::class == javaResource::class

    override fun map(javaResource: Resource): ElasticPool = ElasticPool(
        javaResource as
            com.pulumi.azurenative.sql.ElasticPool,
    )
}

/**
 * @see [ElasticPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ElasticPool].
 */
public suspend fun elasticPool(name: String, block: suspend ElasticPoolResourceBuilder.() -> Unit):
    ElasticPool {
    val builder = ElasticPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ElasticPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun elasticPool(name: String): ElasticPool {
    val builder = ElasticPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
