@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.EncryptionProtectorArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ServerKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The server encryption protector.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update the encryption protector to key vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionProtector = new AzureNative.Sql.EncryptionProtector("encryptionProtector", new()
 *     {
 *         AutoRotationEnabled = false,
 *         EncryptionProtectorName = "current",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyName = "someVault_someKey_01234567890123456789012345678901",
 *         ServerKeyType = "AzureKeyVault",
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewEncryptionProtector(ctx, "encryptionProtector", &sql.EncryptionProtectorArgs{
 * 			AutoRotationEnabled:     pulumi.Bool(false),
 * 			EncryptionProtectorName: pulumi.String("current"),
 * 			ResourceGroupName:       pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyName:           pulumi.String("someVault_someKey_01234567890123456789012345678901"),
 * 			ServerKeyType:           pulumi.String("AzureKeyVault"),
 * 			ServerName:              pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.EncryptionProtector;
 * import com.pulumi.azurenative.sql.EncryptionProtectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionProtector = new EncryptionProtector("encryptionProtector", EncryptionProtectorArgs.builder()
 *             .autoRotationEnabled(false)
 *             .encryptionProtectorName("current")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyName("someVault_someKey_01234567890123456789012345678901")
 *             .serverKeyType("AzureKeyVault")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ### Update the encryption protector to service managed
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionProtector = new AzureNative.Sql.EncryptionProtector("encryptionProtector", new()
 *     {
 *         EncryptionProtectorName = "current",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyName = "ServiceManaged",
 *         ServerKeyType = "ServiceManaged",
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewEncryptionProtector(ctx, "encryptionProtector", &sql.EncryptionProtectorArgs{
 * 			EncryptionProtectorName: pulumi.String("current"),
 * 			ResourceGroupName:       pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyName:           pulumi.String("ServiceManaged"),
 * 			ServerKeyType:           pulumi.String("ServiceManaged"),
 * 			ServerName:              pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.EncryptionProtector;
 * import com.pulumi.azurenative.sql.EncryptionProtectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionProtector = new EncryptionProtector("encryptionProtector", EncryptionProtectorArgs.builder()
 *             .encryptionProtectorName("current")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyName("ServiceManaged")
 *             .serverKeyType("ServiceManaged")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:EncryptionProtector current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}
 * ```
 * @property autoRotationEnabled Key auto rotation opt-in flag. Either true or false.
 * @property encryptionProtectorName The name of the encryption protector to be updated.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverKeyName The name of the server key.
 * @property serverKeyType The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
 * @property serverName The name of the server.
 */
public data class EncryptionProtectorArgs(
    public val autoRotationEnabled: Output<Boolean>? = null,
    public val encryptionProtectorName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverKeyName: Output<String>? = null,
    public val serverKeyType: Output<Either<String, ServerKeyType>>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.EncryptionProtectorArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.EncryptionProtectorArgs =
        com.pulumi.azurenative.sql.EncryptionProtectorArgs.builder()
            .autoRotationEnabled(autoRotationEnabled?.applyValue({ args0 -> args0 }))
            .encryptionProtectorName(encryptionProtectorName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverKeyName(serverKeyName?.applyValue({ args0 -> args0 }))
            .serverKeyType(
                serverKeyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionProtectorArgs].
 */
@PulumiTagMarker
public class EncryptionProtectorArgsBuilder internal constructor() {
    private var autoRotationEnabled: Output<Boolean>? = null

    private var encryptionProtectorName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverKeyName: Output<String>? = null

    private var serverKeyType: Output<Either<String, ServerKeyType>>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value Key auto rotation opt-in flag. Either true or false.
     */
    @JvmName("ytcinauonspoxeim")
    public suspend fun autoRotationEnabled(`value`: Output<Boolean>) {
        this.autoRotationEnabled = value
    }

    /**
     * @param value The name of the encryption protector to be updated.
     */
    @JvmName("oupepskwselntoxh")
    public suspend fun encryptionProtectorName(`value`: Output<String>) {
        this.encryptionProtectorName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("asgairvxmdolcikb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server key.
     */
    @JvmName("crikffblyrxpjdnt")
    public suspend fun serverKeyName(`value`: Output<String>) {
        this.serverKeyName = value
    }

    /**
     * @param value The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("ynbotfcilwuqmgci")
    public suspend fun serverKeyType(`value`: Output<Either<String, ServerKeyType>>) {
        this.serverKeyType = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("kpoghtcexpmhhiwh")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Key auto rotation opt-in flag. Either true or false.
     */
    @JvmName("tspehbcbvcgngjve")
    public suspend fun autoRotationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRotationEnabled = mapped
    }

    /**
     * @param value The name of the encryption protector to be updated.
     */
    @JvmName("pmcyjosaydgefusp")
    public suspend fun encryptionProtectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionProtectorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xsysnthsmlvfluup")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server key.
     */
    @JvmName("tfskdwppheurique")
    public suspend fun serverKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKeyName = mapped
    }

    /**
     * @param value The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("gxncvyqqonycoeyc")
    public suspend fun serverKeyType(`value`: Either<String, ServerKeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("rxptxbrenrpmbjap")
    public fun serverKeyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("uevqvbssfikptxnf")
    public fun serverKeyType(`value`: ServerKeyType) {
        val toBeMapped = Either.ofRight<String, ServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("wdtcuaadqurexaom")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): EncryptionProtectorArgs = EncryptionProtectorArgs(
        autoRotationEnabled = autoRotationEnabled,
        encryptionProtectorName = encryptionProtectorName,
        resourceGroupName = resourceGroupName,
        serverKeyName = serverKeyName,
        serverKeyType = serverKeyType,
        serverName = serverName,
    )
}
