@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.InstanceFailoverGroupArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.InstanceFailoverGroupReadOnlyEndpointArgs
import com.pulumi.azurenative.sql.kotlin.inputs.InstanceFailoverGroupReadOnlyEndpointArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.InstanceFailoverGroupReadWriteEndpointArgs
import com.pulumi.azurenative.sql.kotlin.inputs.InstanceFailoverGroupReadWriteEndpointArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstancePairInfoArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstancePairInfoArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.PartnerRegionInfoArgs
import com.pulumi.azurenative.sql.kotlin.inputs.PartnerRegionInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An instance failover group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create failover group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instanceFailoverGroup = new AzureNative.Sql.InstanceFailoverGroup("instanceFailoverGroup", new()
 *     {
 *         FailoverGroupName = "failover-group-test-3",
 *         LocationName = "Japan East",
 *         ManagedInstancePairs = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ManagedInstancePairInfoArgs
 *             {
 *                 PartnerManagedInstanceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance",
 *                 PrimaryManagedInstanceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance",
 *             },
 *         },
 *         PartnerRegions = new[]
 *         {
 *             new AzureNative.Sql.Inputs.PartnerRegionInfoArgs
 *             {
 *                 Location = "Japan West",
 *             },
 *         },
 *         ReadOnlyEndpoint = new AzureNative.Sql.Inputs.InstanceFailoverGroupReadOnlyEndpointArgs
 *         {
 *             FailoverPolicy = "Disabled",
 *         },
 *         ReadWriteEndpoint = new AzureNative.Sql.Inputs.InstanceFailoverGroupReadWriteEndpointArgs
 *         {
 *             FailoverPolicy = "Automatic",
 *             FailoverWithDataLossGracePeriodMinutes = 480,
 *         },
 *         ResourceGroupName = "Default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewInstanceFailoverGroup(ctx, "instanceFailoverGroup", &sql.InstanceFailoverGroupArgs{
 * 			FailoverGroupName: pulumi.String("failover-group-test-3"),
 * 			LocationName:      pulumi.String("Japan East"),
 * 			ManagedInstancePairs: []sql.ManagedInstancePairInfoArgs{
 * 				{
 * 					PartnerManagedInstanceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance"),
 * 					PrimaryManagedInstanceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance"),
 * 				},
 * 			},
 * 			PartnerRegions: []sql.PartnerRegionInfoArgs{
 * 				{
 * 					Location: pulumi.String("Japan West"),
 * 				},
 * 			},
 * 			ReadOnlyEndpoint: &sql.InstanceFailoverGroupReadOnlyEndpointArgs{
 * 				FailoverPolicy: pulumi.String("Disabled"),
 * 			},
 * 			ReadWriteEndpoint: &sql.InstanceFailoverGroupReadWriteEndpointArgs{
 * 				FailoverPolicy:                         pulumi.String("Automatic"),
 * 				FailoverWithDataLossGracePeriodMinutes: pulumi.Int(480),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.InstanceFailoverGroup;
 * import com.pulumi.azurenative.sql.InstanceFailoverGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instanceFailoverGroup = new InstanceFailoverGroup("instanceFailoverGroup", InstanceFailoverGroupArgs.builder()
 *             .failoverGroupName("failover-group-test-3")
 *             .locationName("Japan East")
 *             .managedInstancePairs(Map.ofEntries(
 *                 Map.entry("partnerManagedInstanceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance"),
 *                 Map.entry("primaryManagedInstanceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance")
 *             ))
 *             .partnerRegions(Map.of("location", "Japan West"))
 *             .readOnlyEndpoint(Map.of("failoverPolicy", "Disabled"))
 *             .readWriteEndpoint(Map.ofEntries(
 *                 Map.entry("failoverPolicy", "Automatic"),
 *                 Map.entry("failoverWithDataLossGracePeriodMinutes", 480)
 *             ))
 *             .resourceGroupName("Default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:InstanceFailoverGroup failover-group-test-3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}
 * ```
 * @property failoverGroupName The name of the failover group.
 * @property locationName The name of the region where the resource is located.
 * @property managedInstancePairs List of managed instance pairs in the failover group.
 * @property partnerRegions Partner region information for the failover group.
 * @property readOnlyEndpoint Read-only endpoint of the failover group instance.
 * @property readWriteEndpoint Read-write endpoint of the failover group instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class InstanceFailoverGroupArgs(
    public val failoverGroupName: Output<String>? = null,
    public val locationName: Output<String>? = null,
    public val managedInstancePairs: Output<List<ManagedInstancePairInfoArgs>>? = null,
    public val partnerRegions: Output<List<PartnerRegionInfoArgs>>? = null,
    public val readOnlyEndpoint: Output<InstanceFailoverGroupReadOnlyEndpointArgs>? = null,
    public val readWriteEndpoint: Output<InstanceFailoverGroupReadWriteEndpointArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.InstanceFailoverGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.InstanceFailoverGroupArgs =
        com.pulumi.azurenative.sql.InstanceFailoverGroupArgs.builder()
            .failoverGroupName(failoverGroupName?.applyValue({ args0 -> args0 }))
            .locationName(locationName?.applyValue({ args0 -> args0 }))
            .managedInstancePairs(
                managedInstancePairs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .partnerRegions(
                partnerRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .readOnlyEndpoint(readOnlyEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readWriteEndpoint(readWriteEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFailoverGroupArgs].
 */
@PulumiTagMarker
public class InstanceFailoverGroupArgsBuilder internal constructor() {
    private var failoverGroupName: Output<String>? = null

    private var locationName: Output<String>? = null

    private var managedInstancePairs: Output<List<ManagedInstancePairInfoArgs>>? = null

    private var partnerRegions: Output<List<PartnerRegionInfoArgs>>? = null

    private var readOnlyEndpoint: Output<InstanceFailoverGroupReadOnlyEndpointArgs>? = null

    private var readWriteEndpoint: Output<InstanceFailoverGroupReadWriteEndpointArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the failover group.
     */
    @JvmName("phwhtyqhvfvhngsq")
    public suspend fun failoverGroupName(`value`: Output<String>) {
        this.failoverGroupName = value
    }

    /**
     * @param value The name of the region where the resource is located.
     */
    @JvmName("wuxonlcocxfycdfo")
    public suspend fun locationName(`value`: Output<String>) {
        this.locationName = value
    }

    /**
     * @param value List of managed instance pairs in the failover group.
     */
    @JvmName("sydhcrlieuewgiko")
    public suspend fun managedInstancePairs(`value`: Output<List<ManagedInstancePairInfoArgs>>) {
        this.managedInstancePairs = value
    }

    @JvmName("qgrfhbqwwwgkreox")
    public suspend fun managedInstancePairs(vararg values: Output<ManagedInstancePairInfoArgs>) {
        this.managedInstancePairs = Output.all(values.asList())
    }

    /**
     * @param values List of managed instance pairs in the failover group.
     */
    @JvmName("bfqbbbukfthsalka")
    public suspend fun managedInstancePairs(values: List<Output<ManagedInstancePairInfoArgs>>) {
        this.managedInstancePairs = Output.all(values)
    }

    /**
     * @param value Partner region information for the failover group.
     */
    @JvmName("svvamkhjbigkcvib")
    public suspend fun partnerRegions(`value`: Output<List<PartnerRegionInfoArgs>>) {
        this.partnerRegions = value
    }

    @JvmName("qhncnxvjtaaaeslr")
    public suspend fun partnerRegions(vararg values: Output<PartnerRegionInfoArgs>) {
        this.partnerRegions = Output.all(values.asList())
    }

    /**
     * @param values Partner region information for the failover group.
     */
    @JvmName("mkptyrihwmlauqtt")
    public suspend fun partnerRegions(values: List<Output<PartnerRegionInfoArgs>>) {
        this.partnerRegions = Output.all(values)
    }

    /**
     * @param value Read-only endpoint of the failover group instance.
     */
    @JvmName("fienkevkinywcyjq")
    public suspend fun readOnlyEndpoint(`value`: Output<InstanceFailoverGroupReadOnlyEndpointArgs>) {
        this.readOnlyEndpoint = value
    }

    /**
     * @param value Read-write endpoint of the failover group instance.
     */
    @JvmName("jegkmndhgsreraax")
    public suspend
    fun readWriteEndpoint(`value`: Output<InstanceFailoverGroupReadWriteEndpointArgs>) {
        this.readWriteEndpoint = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("outasvoslsdlekjn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the failover group.
     */
    @JvmName("jbhilokmbqkqwova")
    public suspend fun failoverGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverGroupName = mapped
    }

    /**
     * @param value The name of the region where the resource is located.
     */
    @JvmName("njqbehfuxdefvgjp")
    public suspend fun locationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationName = mapped
    }

    /**
     * @param value List of managed instance pairs in the failover group.
     */
    @JvmName("xuqdylpdxijokikl")
    public suspend fun managedInstancePairs(`value`: List<ManagedInstancePairInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstancePairs = mapped
    }

    /**
     * @param argument List of managed instance pairs in the failover group.
     */
    @JvmName("gjkhewdqtditeemc")
    public suspend
    fun managedInstancePairs(argument: List<suspend ManagedInstancePairInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedInstancePairInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedInstancePairs = mapped
    }

    /**
     * @param argument List of managed instance pairs in the failover group.
     */
    @JvmName("duragkxvkbkyaayn")
    public suspend fun managedInstancePairs(
        vararg
        argument: suspend ManagedInstancePairInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedInstancePairInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedInstancePairs = mapped
    }

    /**
     * @param argument List of managed instance pairs in the failover group.
     */
    @JvmName("hjoipbacfmulpssv")
    public suspend
    fun managedInstancePairs(argument: suspend ManagedInstancePairInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedInstancePairInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.managedInstancePairs = mapped
    }

    /**
     * @param values List of managed instance pairs in the failover group.
     */
    @JvmName("rnhhawsydgkwdvso")
    public suspend fun managedInstancePairs(vararg values: ManagedInstancePairInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedInstancePairs = mapped
    }

    /**
     * @param value Partner region information for the failover group.
     */
    @JvmName("fevnxxksnlwdiwdu")
    public suspend fun partnerRegions(`value`: List<PartnerRegionInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegions = mapped
    }

    /**
     * @param argument Partner region information for the failover group.
     */
    @JvmName("ocssnuwraefhywqy")
    public suspend
    fun partnerRegions(argument: List<suspend PartnerRegionInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PartnerRegionInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partnerRegions = mapped
    }

    /**
     * @param argument Partner region information for the failover group.
     */
    @JvmName("fqbgjkvpjshyxtxd")
    public suspend fun partnerRegions(
        vararg
        argument: suspend PartnerRegionInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PartnerRegionInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partnerRegions = mapped
    }

    /**
     * @param argument Partner region information for the failover group.
     */
    @JvmName("osparwdsryiaycpm")
    public suspend fun partnerRegions(argument: suspend PartnerRegionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PartnerRegionInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.partnerRegions = mapped
    }

    /**
     * @param values Partner region information for the failover group.
     */
    @JvmName("glssrsquhpsckcmv")
    public suspend fun partnerRegions(vararg values: PartnerRegionInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerRegions = mapped
    }

    /**
     * @param value Read-only endpoint of the failover group instance.
     */
    @JvmName("prcbswgddjkxceem")
    public suspend fun readOnlyEndpoint(`value`: InstanceFailoverGroupReadOnlyEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyEndpoint = mapped
    }

    /**
     * @param argument Read-only endpoint of the failover group instance.
     */
    @JvmName("lnwbugaxpevapbhw")
    public suspend
    fun readOnlyEndpoint(argument: suspend InstanceFailoverGroupReadOnlyEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceFailoverGroupReadOnlyEndpointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.readOnlyEndpoint = mapped
    }

    /**
     * @param value Read-write endpoint of the failover group instance.
     */
    @JvmName("juhuuykhtjixblao")
    public suspend fun readWriteEndpoint(`value`: InstanceFailoverGroupReadWriteEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readWriteEndpoint = mapped
    }

    /**
     * @param argument Read-write endpoint of the failover group instance.
     */
    @JvmName("sxburcntkvhyiqse")
    public suspend
    fun readWriteEndpoint(argument: suspend InstanceFailoverGroupReadWriteEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceFailoverGroupReadWriteEndpointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.readWriteEndpoint = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("scrmboksffriyrep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): InstanceFailoverGroupArgs = InstanceFailoverGroupArgs(
        failoverGroupName = failoverGroupName,
        locationName = locationName,
        managedInstancePairs = managedInstancePairs,
        partnerRegions = partnerRegions,
        readOnlyEndpoint = readOnlyEndpoint,
        readWriteEndpoint = readWriteEndpoint,
        resourceGroupName = resourceGroupName,
    )
}
